/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.core;

import io.debezium.pipeline.signal.actions.snapshotting.AdditionalCondition;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.relational.TableId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=1)
@State(value=Scope.Thread)
@Warmup(iterations=2, time=5)
@Measurement(iterations=2, time=5)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.Throughput})
public class IncrementalSnapshotContextPerf {
    private SignalBasedIncrementalSnapshotContext<TableId> snapshotContext;
    @Param(value={"1", "5", "10", "50", "100"})
    private int numberOfTableToSnapshot;

    @Setup(value=Level.Trial)
    public void setUp() {
        this.snapshotContext = new SignalBasedIncrementalSnapshotContext(false);
        List<String> dataCollectionIds = this.generateDataCollectionIds(this.numberOfTableToSnapshot);
        this.snapshotContext.addDataCollectionNamesToSnapshot("1", dataCollectionIds, dataCollectionIds.stream().map(id -> AdditionalCondition.AdditionalConditionBuilder.builder().dataCollection(Pattern.compile(id)).filter("color='blue'").build()).collect(Collectors.toList()), "");
    }

    private List<String> generateDataCollectionIds(int number) {
        return IntStream.rangeClosed(1, number).mapToObj(i -> IntStream.rangeClosed(1, number).mapToObj(j -> String.format("%s.%s", "db" + i, "table" + j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Benchmark
    public void store() {
        HashMap offset = new HashMap();
        this.snapshotContext.store(offset);
    }
}

