/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.base.DefaultQueueProvider;
import io.debezium.connector.base.QueueProvider;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.DebeziumHeaderProducer;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerChangeEventSourceCoordinator;
import io.debezium.connector.sqlserver.SqlServerChangeEventSourceFactory;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerErrorHandler;
import io.debezium.connector.sqlserver.SqlServerEventMetadataProvider;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerTaskContext;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.connector.sqlserver.metrics.SqlServerMetricsFactory;
import io.debezium.document.DocumentReader;
import io.debezium.heartbeat.HeartbeatFactory;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorTask
extends BaseSourceTask<SqlServerPartition, SqlServerOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorTask.class);
    private static final String CONTEXT_NAME = "sql-server-connector-task";
    private volatile SqlServerTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile SqlServerConnection dataConnection;
    private volatile SqlServerConnection metadataConnection;
    private volatile SqlServerErrorHandler errorHandler;
    private volatile SqlServerDatabaseSchema schema;

    public String version() {
        return Module.version();
    }

    public ChangeEventSourceCoordinator<SqlServerPartition, SqlServerOffsetContext> start(Configuration config) {
        Clock clock = Clock.system();
        config = ((Configuration.Builder)config.edit().withDefault("driver.responseBuffering", "adaptive").withDefault("driver.fetchSize", 10000)).build();
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(config);
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY, true);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        SqlServerValueConverters valueConverters = new SqlServerValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode(), connectorConfig.binaryHandlingMode());
        DefaultMainConnectionProvidingConnectionFactory connectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> new SqlServerConnection(connectorConfig, valueConverters, connectorConfig.getSkippedOperations(), connectorConfig.useSingleDatabase(), connectorConfig.getOptionRecompile()));
        this.dataConnection = (SqlServerConnection)connectionFactory.mainConnection();
        this.metadataConnection = new SqlServerConnection(connectorConfig, valueConverters, connectorConfig.getSkippedOperations(), connectorConfig.useSingleDatabase());
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        CustomConverterRegistry customConverterRegistry = (CustomConverterRegistry)connectorConfig.getServiceRegistry().tryGetService(CustomConverterRegistry.class);
        this.schema = new SqlServerDatabaseSchema(connectorConfig, this.metadataConnection.getDefaultValueConverter(), (ValueConverterProvider)valueConverters, (TopicNamingStrategy<TableId>)topicNamingStrategy, schemaNameAdjuster, customConverterRegistry);
        this.schema.initializeStorage();
        this.taskContext = new SqlServerTaskContext(config, connectorConfig);
        Offsets offsets = this.getPreviousOffsets(new SqlServerPartition.Provider(connectorConfig), new SqlServerOffsetContext.Loader(connectorConfig));
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)this.metadataConnection);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverters);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)offsets);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CDC_SOURCE_TASK_CONTEXT, (Object)this.taskContext);
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        if (connectorConfig.getGuardrailCollectionsMax() <= 0) {
            LOGGER.info("Guardrail validation skipped");
        } else {
            this.validateGuardrailLimits(connectorConfig, this.dataConnection);
        }
        this.validateSchemaHistory((CommonConnectorConfig)connectorConfig, this.dataConnection::validateLogPosition, offsets, (DatabaseSchema)this.schema, snapshotterService.getSnapshotter());
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).queueProvider((QueueProvider)new DefaultQueueProvider(connectorConfig.getMaxQueueSize())).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new SqlServerErrorHandler(connectorConfig, this.queue, this.errorHandler);
        SqlServerEventMetadataProvider metadataProvider = new SqlServerEventMetadataProvider();
        SignalProcessor signalProcessor = new SignalProcessor(SqlServerConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), offsets);
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventMetadataProvider)metadataProvider, new HeartbeatFactory().getScheduledHeartbeat((CommonConnectorConfig)connectorConfig, () -> ((MainConnectionProvidingConnectionFactory)connectionFactory).newConnection(), exception -> {
            String sqlErrorId = exception.getMessage();
            throw new DebeziumException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
        }, this.queue), schemaNameAdjuster, signalProcessor, (DebeziumHeaderProducer)connectorConfig.getServiceRegistry().tryGetService(DebeziumHeaderProducer.class));
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        SqlServerChangeEventSourceCoordinator coordinator = new SqlServerChangeEventSourceCoordinator((Offsets<SqlServerPartition, SqlServerOffsetContext>)offsets, this.errorHandler, (Class<? extends SourceConnector>)SqlServerConnector.class, (CommonConnectorConfig)connectorConfig, new SqlServerChangeEventSourceFactory(connectorConfig, (MainConnectionProvidingConnectionFactory<SqlServerConnection>)connectionFactory, this.metadataConnection, this.errorHandler, (EventDispatcher<SqlServerPartition, TableId>)dispatcher, clock, this.schema, (NotificationService<SqlServerPartition, SqlServerOffsetContext>)notificationService, snapshotterService), new SqlServerMetricsFactory(offsets.getPartitions()), (EventDispatcher<SqlServerPartition, ?>)dispatcher, (DatabaseSchema<?>)this.schema, clock, (SignalProcessor<SqlServerPartition, SqlServerOffsetContext>)signalProcessor, (NotificationService<SqlServerPartition, SqlServerOffsetContext>)notificationService, snapshotterService);
        coordinator.start(this.taskContext, (ChangeEventQueueMetrics)this.queue, metadataProvider);
        return coordinator;
    }

    protected String connectorName() {
        return Module.name();
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    protected Optional<ErrorHandler> getErrorHandler() {
        return Optional.of(this.errorHandler);
    }

    protected void resetErrorHandlerRetriesIfNeeded(List<SourceRecord> records) {
        if (this.coordinator.getErrorHandler().getRetries() > 0 && ((SqlServerChangeEventSourceCoordinator)this.coordinator).firstStreamingIterationCompletedSuccessfully()) {
            this.coordinator.getErrorHandler().resetRetries();
        }
    }

    protected void doStop() {
        try {
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC metadata connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return SqlServerConnectorConfig.ALL_FIELDS;
    }

    private void validateGuardrailLimits(SqlServerConnectorConfig connectorConfig, SqlServerConnection connection) {
        try {
            Set<TableId> allTableIds = connection.getAllTableIds(connectorConfig.getDatabaseNames());
            List tableNames = allTableIds.stream().filter(tableId -> connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)).map(TableId::toString).collect(Collectors.toList());
            connectorConfig.validateGuardrailLimits(tableNames.size(), tableNames);
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to validate guardrail limits", (Throwable)e);
        }
    }
}

