/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerDatabaseSchema.class);

    public SqlServerDatabaseSchema(SqlServerConnectorConfig connectorConfig, SchemaNameAdjuster schemaNameAdjuster, TopicSelector<TableId> topicSelector, SqlServerConnection connection) {
        super((HistorizedRelationalDatabaseConnectorConfig)connectorConfig, topicSelector, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)new SqlServerValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode()), schemaNameAdjuster, connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getSanitizeFieldNames()), false, connectorConfig.getKeyMapper());
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        Table table = (Table)schemaChange.getTables().iterator().next();
        this.buildAndRegisterSchema(table);
        this.tables().overwriteTable(table);
        TableChanges tableChanges = null;
        if (schemaChange.getType() == SchemaChangeEvent.SchemaChangeEventType.CREATE) {
            tableChanges = new TableChanges();
            tableChanges.create(table);
        } else if (schemaChange.getType() == SchemaChangeEvent.SchemaChangeEventType.ALTER) {
            tableChanges = new TableChanges();
            tableChanges.alter(table);
        }
        this.record(schemaChange, tableChanges);
    }

    protected DdlParser getDdlParser() {
        return null;
    }
}

