/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.util.IoUtil;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnection
extends JdbcConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(SqlServerConnection.class);
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String ENABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=0)\nEXEC sys.sp_cdc_enable_db";
    private static final String DISABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name='#' AND is_cdc_enabled=1)\nEXEC sys.sp_cdc_disable_db";
    private static final String ENABLE_TABLE_CDC = "IF EXISTS(select 1 from sys.tables where name = '#' AND is_tracked_by_cdc=0)\nEXEC sys.sp_cdc_enable_table @source_schema = N'dbo', @source_name = N'#', @role_name = NULL, @supports_net_changes = 0";
    private static final String CDC_WRAPPERS_DML;
    private static final String GET_MAX_LSN = "SELECT sys.fn_cdc_get_max_lsn()";
    private static final String LOCK_TABLE = "SELECT * FROM # WITH (TABLOCKX)";
    private static final String LSN_TO_TIMESTAMP = "SELECT sys.fn_cdc_map_lsn_to_time(?)";
    private static final String INCREMENT_LSN = "SELECT sys.fn_cdc_increment_lsn(?)";
    private static final String GET_ALL_CHANGES_FOR_TABLE = "SELECT * FROM cdc.fn_cdc_get_all_changes_#(ISNULL(?,sys.fn_cdc_get_min_lsn('#')), ?, N'all update old')";

    public SqlServerConnection(Configuration config, JdbcConnection.ConnectionFactory factory) {
        super(config, factory);
    }

    public void enableDbCdc(String name) throws SQLException {
        Objects.requireNonNull(name);
        this.execute(new String[]{ENABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
    }

    public void disableDbCdc(String name) throws SQLException {
        Objects.requireNonNull(name);
        this.execute(new String[]{DISABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, name)});
    }

    public void enableTableCdc(String name) throws SQLException {
        Objects.requireNonNull(name);
        String enableCdcForTableStmt = ENABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, name);
        String generateWrapperFunctionsStmts = CDC_WRAPPERS_DML.replaceAll(STATEMENTS_PLACEHOLDER, name);
        this.execute(new String[]{enableCdcForTableStmt, generateWrapperFunctionsStmts});
    }

    public Lsn getMaxLsn() throws SQLException {
        return (Lsn)this.queryAndMap(GET_MAX_LSN, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current maximum lsn is {}", (Object)ret);
            return ret;
        }, "Maximum LSN query must return exactly one value"));
    }

    public void getChangesForTable(TableId tableId, Lsn fromLsn, Lsn toLsn, JdbcConnection.ResultSetConsumer consumer) throws SQLException {
        String query = GET_ALL_CHANGES_FOR_TABLE.replace(STATEMENTS_PLACEHOLDER, this.cdcNameForTable(tableId));
        this.prepareQuery(query, statement -> {
            statement.setBytes(1, fromLsn.getBinary());
            statement.setBytes(2, toLsn.getBinary());
        }, consumer);
    }

    public void getChangesForTables(TableId[] tableIds, Lsn fromLsn, Lsn toLsn, JdbcConnection.BlockingMultiResultSetConsumer consumer) throws SQLException, InterruptedException {
        String[] queries = new String[tableIds.length];
        int idx = 0;
        for (TableId tableId : tableIds) {
            String query = GET_ALL_CHANGES_FOR_TABLE.replace(STATEMENTS_PLACEHOLDER, this.cdcNameForTable(tableId));
            queries[idx++] = query;
            LOGGER.trace("Getting changes for table {} in range[{}, {}]", new Object[]{tableId, fromLsn, toLsn});
        }
        this.prepareQuery(queries, statement -> {
            statement.setBytes(1, fromLsn.getBinary());
            statement.setBytes(2, toLsn.getBinary());
        }, consumer);
    }

    public Lsn incrementLsn(Lsn lsn) throws SQLException {
        String query = INCREMENT_LSN;
        return (Lsn)this.prepareQueryAndMap(INCREMENT_LSN, statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Increasing lsn from {} to {}", (Object)lsn, (Object)ret);
            return ret;
        }, "Increment LSN query must return exactly one value"));
    }

    public Instant timestampOfLsn(Lsn lsn) throws SQLException {
        String query = LSN_TO_TIMESTAMP;
        if (lsn.getBinary() == null) {
            return null;
        }
        return (Instant)this.prepareQueryAndMap(LSN_TO_TIMESTAMP, statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Timestamp ts = rs.getTimestamp(1);
            Instant ret = ts == null ? null : ts.toInstant();
            LOGGER.trace("Timestamp of lsn {} is {}", (Object)lsn, (Object)ret);
            return ret;
        }, "LSN to timestamp query must return exactly one value"));
    }

    public void lockTable(TableId tableId) throws SQLException {
        String lockTableStmt = LOCK_TABLE.replace(STATEMENTS_PLACEHOLDER, tableId.table());
        this.execute(new String[]{lockTableStmt});
    }

    private String cdcNameForTable(TableId tableId) {
        return tableId.schema() + '_' + tableId.table();
    }

    private <T> JdbcConnection.ResultSetMapper<T> singleResultMapper(ResultSetExtractor<T> extractor, String error) throws SQLException {
        return rs -> {
            if (rs.next()) {
                Object ret = extractor.apply(rs);
                if (!rs.next()) {
                    return ret;
                }
            }
            throw new IllegalStateException(error);
        };
    }

    static {
        try {
            ClassLoader classLoader = SqlServerConnection.class.getClassLoader();
            CDC_WRAPPERS_DML = IoUtil.read((InputStream)classLoader.getResourceAsStream("generate_cdc_wrappers.sql"));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load SQL Server statements", e);
        }
    }

    private static interface ResultSetExtractor<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

