/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.connector.postgresql.connection.ReplicaIdentityInfo;
import io.debezium.function.Predicates;
import io.debezium.relational.TableId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Immutable
public class ReplicaIdentityMapper {
    public static final Pattern REPLICA_AUTO_SET_PATTERN = Pattern.compile("(?i)^\\s*(?<tablepredicate>[^\\s:]+):(?<replicaidentity>DEFAULT|(INDEX) (?<indexname>.\\w*)|FULL|NOTHING)\\s*$");
    public static final Pattern PATTERN_SPLIT = Pattern.compile(",");
    private Map<Predicate<TableId>, ReplicaIdentityInfo> replicaIdentityPredicateMap;
    private final String replicaAutoSetValue;

    public ReplicaIdentityMapper(String replicaAutoSetValue) {
        this.replicaAutoSetValue = replicaAutoSetValue;
    }

    public Optional<ReplicaIdentityInfo> findReplicaIdentity(TableId tableId) throws DebeziumException {
        if (this.replicaIdentityPredicateMap == null) {
            this.replicaIdentityPredicateMap = this.getReplicaIdentityPredicateMap();
        }
        return this.replicaIdentityPredicateMap.entrySet().stream().filter(item -> ((Predicate)item.getKey()).test(tableId)).map(Map.Entry::getValue).reduce((a, b) -> {
            throw new DebeziumException(String.format("More than one Regular expressions matched table %s", tableId));
        });
    }

    private Map<Predicate<TableId>, ReplicaIdentityInfo> getReplicaIdentityPredicateMap() {
        if (this.replicaAutoSetValue == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(PATTERN_SPLIT.split(this.replicaAutoSetValue)).map(REPLICA_AUTO_SET_PATTERN::matcher).filter(Matcher::matches).collect(Collectors.toMap(t -> Predicates.includes((String)t.group("tablepredicate"), TableId::toString), t -> new ReplicaIdentityInfo(ReplicaIdentityInfo.ReplicaIdentity.valueOf(t.group("replicaidentity").replaceAll("\\s.*", "")), t.group("indexname"))));
    }
}

