/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;

public class UnchangedToastedReplicationMessageColumn
extends AbstractReplicationMessageColumn {
    private static final String TYPE_ARRAY_SUFFIX = "[]";
    private static final String TYPR_ARRAY_PREFIX = "_";
    public static final Object UNCHANGED_TOAST_VALUE = new Object();
    public static final Object UNCHANGED_TEXT_ARRAY_TOAST_VALUE = new Object();
    public static final Object UNCHANGED_INT_ARRAY_TOAST_VALUE = new Object();
    public static final Object UNCHANGED_BIGINT_ARRAY_TOAST_VALUE = new Object();
    public static final Object UNCHANGED_HSTORE_TOAST_VALUE = new Object();
    private Object unchangedToastValue;

    public UnchangedToastedReplicationMessageColumn(String columnName, PostgresType type, String typeWithModifiers, boolean optional) {
        super(columnName, type, typeWithModifiers, optional);
        this.setUnchangedToastValue(typeWithModifiers);
    }

    @Override
    public boolean isToastedColumn() {
        return true;
    }

    @Override
    public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        return this.unchangedToastValue;
    }

    private void setUnchangedToastValue(String typeWithModifiers) {
        switch (typeWithModifiers = this.removeSizeModifierFromArrayTypes(typeWithModifiers)) {
            case "text[]": 
            case "_text": 
            case "character varying[]": 
            case "_varchar": 
            case "json[]": 
            case "_json": 
            case "jsonb[]": 
            case "_jsonb": {
                this.unchangedToastValue = UNCHANGED_TEXT_ARRAY_TOAST_VALUE;
                break;
            }
            case "integer[]": 
            case "_int4": 
            case "_date": {
                this.unchangedToastValue = UNCHANGED_INT_ARRAY_TOAST_VALUE;
                break;
            }
            case "bigint[]": 
            case "_int8": {
                this.unchangedToastValue = UNCHANGED_BIGINT_ARRAY_TOAST_VALUE;
                break;
            }
            case "hstore": {
                this.unchangedToastValue = UNCHANGED_HSTORE_TOAST_VALUE;
                break;
            }
            default: {
                this.unchangedToastValue = UNCHANGED_TOAST_VALUE;
            }
        }
    }

    private boolean isArrayType(String typeWithModifiers) {
        return typeWithModifiers.startsWith(TYPR_ARRAY_PREFIX) || typeWithModifiers.endsWith(TYPE_ARRAY_SUFFIX);
    }

    protected String removeSizeModifierFromArrayTypes(String typeWithModifiers) {
        if (this.isArrayType((String)typeWithModifiers)) {
            int leftParenthesis = ((String)typeWithModifiers).indexOf("(");
            int rightParenthesis = ((String)typeWithModifiers).lastIndexOf(")");
            if (leftParenthesis > 0 && rightParenthesis > 0) {
                typeWithModifiers = rightParenthesis == ((String)typeWithModifiers).length() - 1 ? ((String)typeWithModifiers).substring(0, leftParenthesis) : ((String)typeWithModifiers).substring(0, leftParenthesis) + ((String)typeWithModifiers).substring(rightParenthesis + 1);
            }
        }
        return typeWithModifiers;
    }
}

