/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.Immutable;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.pipeline.ErrorHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.postgresql.util.PSQLException;

public class PostgresErrorHandler
extends ErrorHandler {
    @Immutable
    private static final Set<String> RETRIABLE_EXCEPTION_MESSSAGES;

    public PostgresErrorHandler(String logicalName, ChangeEventQueue<?> queue) {
        super(PostgresConnector.class, logicalName, queue);
    }

    protected boolean isRetriable(Throwable throwable) {
        if (throwable instanceof PSQLException && throwable.getMessage() != null) {
            for (String messageText : RETRIABLE_EXCEPTION_MESSSAGES) {
                if (!throwable.getMessage().contains(messageText)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("Database connection failed when writing to copy");
        tmp.add("Database connection failed when reading from copy");
        tmp.add("FATAL: terminating connection due to administrator command");
        tmp.add("An I/O error occurred while sending to the backend");
        RETRIABLE_EXCEPTION_MESSSAGES = Collections.unmodifiableSet(tmp);
    }
}

