/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.ArrayList;

@NotThreadSafe
public final class SourceInfo
extends BaseSourceInfo {
    public static final String TIMESTAMP_USEC_KEY = "ts_usec";
    public static final String TXID_KEY = "txId";
    public static final String XMIN_KEY = "xmin";
    public static final String LSN_KEY = "lsn";
    public static final String LAST_SNAPSHOT_RECORD_KEY = "last_snapshot_record";
    private final String dbName;
    private Lsn lsn;
    private Lsn[] sequence;
    private Long txId;
    private Long xmin;
    private Instant timestamp;
    private String schemaName;
    private String tableName;

    protected SourceInfo(PostgresConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
        this.dbName = connectorConfig.databaseName();
    }

    protected SourceInfo update(Lsn lsn, Instant commitTime, Long txId, TableId tableId, Long xmin, Lsn lastCommitLsn) {
        this.update(lsn, commitTime, txId, tableId, xmin);
        this.sequence = new Lsn[]{lastCommitLsn, lsn};
        return this;
    }

    protected SourceInfo update(Lsn lsn, Instant commitTime, Long txId, TableId tableId, Long xmin) {
        this.lsn = lsn;
        if (commitTime != null) {
            this.timestamp = commitTime;
        }
        this.txId = txId;
        this.xmin = xmin;
        if (tableId != null && tableId.schema() != null) {
            this.schemaName = tableId.schema();
        }
        if (tableId != null && tableId.table() != null) {
            this.tableName = tableId.table();
        }
        return this;
    }

    protected SourceInfo update(Instant timestamp, TableId tableId) {
        this.timestamp = timestamp;
        if (tableId != null && tableId.schema() != null) {
            this.schemaName = tableId.schema();
        }
        if (tableId != null && tableId.table() != null) {
            this.tableName = tableId.table();
        }
        return this;
    }

    public Lsn lsn() {
        return this.lsn;
    }

    public Long xmin() {
        return this.xmin;
    }

    public String sequence() {
        ArrayList<String> sequence = new ArrayList<String>();
        if (this.sequence != null) {
            for (Lsn lsn : this.sequence) {
                if (lsn == null) {
                    sequence.add(null);
                    continue;
                }
                sequence.add(Long.toString(lsn.asLong()));
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(sequence);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String database() {
        return this.dbName;
    }

    String schemaName() {
        return this.schemaName;
    }

    String tableName() {
        return this.tableName;
    }

    protected Instant timestamp() {
        return this.timestamp;
    }

    protected Long txId() {
        return this.txId;
    }

    public SnapshotRecord snapshot() {
        return super.snapshot();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("source_info[");
        sb.append("server='").append(this.serverName()).append('\'');
        sb.append("db='").append(this.dbName).append('\'');
        if (this.lsn != null) {
            sb.append(", lsn=").append(this.lsn);
        }
        if (this.txId != null) {
            sb.append(", txId=").append(this.txId);
        }
        if (this.xmin != null) {
            sb.append(", xmin=").append(this.xmin);
        }
        if (this.sequence != null) {
            sb.append(", sequence=").append(this.sequence);
        }
        if (this.timestamp != null) {
            sb.append(", timestamp=").append(this.timestamp);
        }
        sb.append(", snapshot=").append(this.snapshot());
        if (this.schemaName != null) {
            sb.append(", schema=").append(this.schemaName);
        }
        if (this.tableName != null) {
            sb.append(", table=").append(this.tableName);
        }
        sb.append(']');
        return sb.toString();
    }
}

