/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresChangeRecordEmitter;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.ReplicationStream;
import io.debezium.connector.postgresql.connection.WalPositionLocator;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.DelayStrategy;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final int GROWING_WAL_WARNING_LOG_INTERVAL = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresStreamingChangeEventSource.class);
    private static final int THROTTLE_NO_MESSAGE_BEFORE_PAUSE = 5;
    private final PostgresConnection connection;
    private final EventDispatcher<TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final PostgresSchema schema;
    private final PostgresOffsetContext offsetContext;
    private final PostgresConnectorConfig connectorConfig;
    private final PostgresTaskContext taskContext;
    private final ReplicationConnection replicationConnection;
    private final AtomicReference<ReplicationStream> replicationStream = new AtomicReference();
    private final Snapshotter snapshotter;
    private final DelayStrategy pauseNoMessage;
    private final boolean hasStartLsnStoredInContext;
    private long numberOfEventsSinceLastEventSentOrWalGrowingWarning = 0L;
    private Lsn lastCompletelyProcessedLsn;

    public PostgresStreamingChangeEventSource(PostgresConnectorConfig connectorConfig, Snapshotter snapshotter, PostgresOffsetContext offsetContext, PostgresConnection connection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, PostgresSchema schema, PostgresTaskContext taskContext, ReplicationConnection replicationConnection) {
        this.connectorConfig = connectorConfig;
        this.connection = connection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext != null ? offsetContext : PostgresOffsetContext.initialContext(connectorConfig, connection, clock);
        this.hasStartLsnStoredInContext = offsetContext != null;
        this.pauseNoMessage = DelayStrategy.constant((long)taskContext.getConfig().getPollInterval().toMillis());
        this.taskContext = taskContext;
        this.snapshotter = snapshotter;
        this.replicationConnection = replicationConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        if (!this.snapshotter.shouldStream()) {
            LOGGER.info("Streaming is not enabled in correct configuration");
            return;
        }
        try {
            WalPositionLocator walPosition;
            if (this.hasStartLsnStoredInContext) {
                Lsn lsn = this.offsetContext.lastCompletelyProcessedLsn() != null ? this.offsetContext.lastCompletelyProcessedLsn() : this.offsetContext.lsn();
                LOGGER.info("Retrieved latest position from stored offset '{}'", (Object)lsn);
                walPosition = new WalPositionLocator(this.offsetContext.lastCommitLsn(), lsn);
                this.replicationStream.compareAndSet(null, this.replicationConnection.startStreaming(lsn, walPosition));
            } else {
                LOGGER.info("No previous LSN found in Kafka, streaming from the latest xlogpos or flushed LSN...");
                walPosition = new WalPositionLocator();
                this.replicationStream.compareAndSet(null, this.replicationConnection.startStreaming(walPosition));
            }
            ReplicationStream stream = this.replicationStream.get();
            stream.startKeepAlive(Executors.newSingleThreadExecutor());
            this.taskContext.refreshSchema(this.connection, true);
            if (!this.isInPreSnapshotCatchUpStreaming()) {
                this.connection.commit();
            }
            this.lastCompletelyProcessedLsn = this.replicationStream.get().startLsn();
            if (walPosition.searchingEnabled()) {
                this.searchWalPosition(context, stream, walPosition);
                try {
                    if (!this.isInPreSnapshotCatchUpStreaming()) {
                        this.connection.commit();
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Commit failed while preparing for reconnect", (Throwable)e);
                }
                walPosition.enableFiltering();
                stream.stopKeepAlive();
                this.replicationConnection.reconnect();
                this.replicationStream.set(this.replicationConnection.startStreaming(walPosition.getLastEventStoredLsn(), walPosition));
                stream = this.replicationStream.get();
                stream.startKeepAlive(Executors.newSingleThreadExecutor());
            }
            this.processMessages(context, stream);
        }
        catch (Throwable e) {
            this.errorHandler.setProducerThrowable(e);
        }
        finally {
            if (this.replicationConnection != null) {
                LOGGER.debug("stopping streaming...");
                ReplicationStream stream = this.replicationStream.get();
                if (stream != null) {
                    stream.stopKeepAlive();
                }
                try {
                    if (!this.isInPreSnapshotCatchUpStreaming()) {
                        this.connection.commit();
                    }
                    this.replicationConnection.close();
                }
                catch (Exception e) {
                    LOGGER.debug("Exception while closing the connection", (Throwable)e);
                }
                this.replicationStream.set(null);
            }
        }
    }

    private void processMessages(ChangeEventSource.ChangeEventSourceContext context, ReplicationStream stream) throws SQLException, InterruptedException {
        LOGGER.info("Processing messages");
        int noMessageIterations = 0;
        while (context.isRunning() && (this.offsetContext.getStreamingStoppingLsn() == null || this.lastCompletelyProcessedLsn.compareTo(this.offsetContext.getStreamingStoppingLsn()) < 0)) {
            boolean receivedMessage = stream.readPending(message -> {
                Lsn lsn = stream.lastReceivedLsn();
                if (message.isLastEventForLsn()) {
                    this.lastCompletelyProcessedLsn = lsn;
                }
                if (message.isTransactionalMessage()) {
                    if (!this.connectorConfig.shouldProvideTransactionMetadata()) {
                        LOGGER.trace("Received transactional message {}", (Object)message);
                        if (message.getOperation() == ReplicationMessage.Operation.COMMIT) {
                            this.commitMessage(lsn);
                        }
                        return;
                    }
                    this.offsetContext.updateWalPosition(lsn, this.lastCompletelyProcessedLsn, message.getCommitTime(), message.getTransactionId(), null, this.taskContext.getSlotXmin(this.connection));
                    if (message.getOperation() == ReplicationMessage.Operation.BEGIN) {
                        this.dispatcher.dispatchTransactionStartedEvent(Long.toString(message.getTransactionId()), (OffsetContext)this.offsetContext);
                    } else if (message.getOperation() == ReplicationMessage.Operation.COMMIT) {
                        this.commitMessage(lsn);
                        this.dispatcher.dispatchTransactionCommittedEvent((OffsetContext)this.offsetContext);
                    }
                    this.maybeWarnAboutGrowingWalBacklog(true);
                } else {
                    TableId tableId = null;
                    if (message.getOperation() != ReplicationMessage.Operation.NOOP) {
                        tableId = PostgresSchema.parse(message.getTable());
                        Objects.requireNonNull(tableId);
                    }
                    this.offsetContext.updateWalPosition(lsn, this.lastCompletelyProcessedLsn, message.getCommitTime(), message.getTransactionId(), tableId, this.taskContext.getSlotXmin(this.connection));
                    boolean dispatched = message.getOperation() != ReplicationMessage.Operation.NOOP && this.dispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new PostgresChangeRecordEmitter(this.offsetContext, this.clock, this.connectorConfig, this.schema, this.connection, message));
                    this.maybeWarnAboutGrowingWalBacklog(dispatched);
                }
            });
            if (receivedMessage) {
                noMessageIterations = 0;
            } else {
                if (this.offsetContext.hasCompletelyProcessedPosition()) {
                    this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
                }
                if (++noMessageIterations >= 5) {
                    noMessageIterations = 0;
                    this.pauseNoMessage.sleepWhen(true);
                }
            }
            if (this.isInPreSnapshotCatchUpStreaming()) continue;
            this.connection.commit();
        }
    }

    private void searchWalPosition(ChangeEventSource.ChangeEventSourceContext context, ReplicationStream stream, WalPositionLocator walPosition) throws SQLException, InterruptedException {
        AtomicReference resumeLsn = new AtomicReference();
        int noMessageIterations = 0;
        LOGGER.info("Searching for WAL resume position");
        while (context.isRunning() && resumeLsn.get() == null) {
            boolean receivedMessage = stream.readPending(message -> {
                Lsn lsn = stream.lastReceivedLsn();
                resumeLsn.set(walPosition.resumeFromLsn(lsn, message).orElse(null));
            });
            if (receivedMessage) {
                noMessageIterations = 0;
                continue;
            }
            if (++noMessageIterations < 5) continue;
            noMessageIterations = 0;
            this.pauseNoMessage.sleepWhen(true);
        }
        LOGGER.info("WAL resume position '{}' discovered", resumeLsn.get());
    }

    private void commitMessage(Lsn lsn) throws SQLException, InterruptedException {
        this.lastCompletelyProcessedLsn = lsn;
        this.offsetContext.updateCommitPosition(lsn, this.lastCompletelyProcessedLsn, null, null, null, this.taskContext.getSlotXmin(this.connection));
        this.maybeWarnAboutGrowingWalBacklog(false);
        this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
    }

    private void maybeWarnAboutGrowingWalBacklog(boolean dispatched) {
        this.numberOfEventsSinceLastEventSentOrWalGrowingWarning = dispatched ? 0L : ++this.numberOfEventsSinceLastEventSentOrWalGrowingWarning;
        if (this.numberOfEventsSinceLastEventSentOrWalGrowingWarning > 10000L && !this.dispatcher.heartbeatsEnabled()) {
            LOGGER.warn("Received {} events which were all filtered out, so no offset could be committed. This prevents the replication slot from acknowledging the processed WAL offsets, causing a growing backlog of non-removeable WAL segments on the database server. Consider to either adjust your filter configuration or enable heartbeat events (via the {} option) to avoid this situation.", (Object)this.numberOfEventsSinceLastEventSentOrWalGrowingWarning, (Object)"heartbeat.interval.ms");
            this.numberOfEventsSinceLastEventSentOrWalGrowingWarning = 0L;
        }
    }

    public void commitOffset(Map<String, ?> offset) {
        try {
            Lsn lsn;
            ReplicationStream replicationStream = this.replicationStream.get();
            Lsn commitLsn = Lsn.valueOf((Long)offset.get("lsn_commit"));
            Lsn changeLsn = Lsn.valueOf((Long)offset.get("lsn_proc"));
            Lsn lsn2 = lsn = commitLsn != null ? commitLsn : changeLsn;
            if (replicationStream != null && lsn != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Flushing LSN to server: {}", (Object)lsn);
                }
                replicationStream.flushLsn(lsn);
            } else {
                LOGGER.debug("Streaming has already stopped, ignoring commit callback...");
            }
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    private boolean isInPreSnapshotCatchUpStreaming() {
        return this.offsetContext.getStreamingStoppingLsn() != null;
    }

    @FunctionalInterface
    public static interface PgConnectionSupplier {
        public BaseConnection get() throws SQLException;
    }
}

