/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.postgresql.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class PostgresSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.postgresql.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("txId", Schema.OPTIONAL_INT64_SCHEMA).field("lsn", Schema.OPTIONAL_INT64_SCHEMA).field("xmin", Schema.OPTIONAL_INT64_SCHEMA).build();

    public PostgresSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        assert (sourceInfo.database() != null && sourceInfo.schemaName() != null && sourceInfo.tableName() != null);
        Struct result = super.commonStruct((AbstractSourceInfo)sourceInfo);
        result.put("schema", (Object)sourceInfo.schemaName());
        result.put("table", (Object)sourceInfo.tableName());
        if (sourceInfo.txId() != null) {
            result.put("txId", (Object)sourceInfo.txId());
        }
        if (sourceInfo.lsn() != null) {
            result.put("lsn", (Object)sourceInfo.lsn());
        }
        if (sourceInfo.xmin() != null) {
            result.put("xmin", (Object)sourceInfo.xmin());
        }
        return result;
    }
}

