/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTopicSelector;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import java.sql.SQLException;

@ThreadSafe
public class PostgresTaskContext
extends CdcSourceTaskContext {
    private final PostgresConnectorConfig config;
    private final PostgresTopicSelector topicSelector;
    private final PostgresSchema schema;

    protected PostgresTaskContext(PostgresConnectorConfig config, PostgresSchema schema, PostgresTopicSelector topicSelector) {
        super("Postgres", config.getLogicalName());
        this.config = config;
        this.topicSelector = topicSelector;
        assert (schema != null);
        this.schema = schema;
    }

    protected PostgresTopicSelector topicSelector() {
        return this.topicSelector;
    }

    protected PostgresSchema schema() {
        return this.schema;
    }

    protected PostgresConnectorConfig config() {
        return this.config;
    }

    protected void refreshSchema(boolean printReplicaIdentityInfo) throws SQLException {
        try (PostgresConnection connection = this.createConnection();){
            this.schema.refresh(connection, printReplicaIdentityInfo);
        }
    }

    protected ReplicationConnection createReplicationConnection() throws SQLException {
        return ReplicationConnection.builder(this.config.jdbcConfig()).withSlot(this.config.slotName()).withPlugin(this.config.plugin()).dropSlotOnClose(this.config.dropSlotOnStop()).statusUpdateIntervalMillis(this.config.statusUpdateIntervalMillis()).withTypeRegistry(this.schema.getTypeRegistry()).build();
    }

    protected PostgresConnection createConnection() {
        return new PostgresConnection(this.config.jdbcConfig());
    }

    PostgresConnectorConfig getConfig() {
        return this.config;
    }
}

