/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.PgOid;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReplicationMessageColumn
implements ReplicationMessage.Column {
    private final String columnName;
    private final String typeWithModifiers;
    private final boolean optional;
    private TypeMetadataImpl typeMetadata;
    private final boolean hasMetadata;

    public AbstractReplicationMessageColumn(String columnName, String typeWithModifiers, boolean optional, boolean hasMetadata) {
        this.columnName = columnName;
        this.typeWithModifiers = typeWithModifiers;
        this.optional = optional;
        this.hasMetadata = hasMetadata;
    }

    private void initMetadata() {
        assert (this.hasMetadata) : "Metadata not available";
        this.typeMetadata = new TypeMetadataImpl(this.columnName, this.typeWithModifiers, this.optional);
    }

    @Override
    public int getOidType() {
        if (this.hasMetadata) {
            this.initMetadata();
            return this.typeMetadata.isArray() ? 2003 : this.doGetOidType();
        }
        return this.doGetOidType();
    }

    @Override
    public int getComponentOidType() {
        this.initMetadata();
        assert (this.typeMetadata.isArray());
        return this.doGetOidType();
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    protected abstract int doGetOidType();

    @Override
    public TypeMetadataImpl getTypeMetadata() {
        this.initMetadata();
        return this.typeMetadata;
    }

    public static class TypeMetadataImpl
    implements ReplicationMessage.ColumnTypeMetadata {
        private static final Logger LOGGER = LoggerFactory.getLogger(TypeMetadataImpl.class);
        private static final Pattern TYPE_PATTERN = Pattern.compile("^(?<schema>[^\\.\\(]+\\.)?(?<full>(?<base>[^(\\[]+)(?:\\((?<mod>.+)\\))?(?<suffix>.*?))(?<array>\\[\\])?$");
        private static final Pattern TYPEMOD_PATTERN = Pattern.compile("\\s*,\\s*");
        private final String schema;
        private final String baseType;
        private final String fullType;
        private Integer length;
        private Integer scale;
        private final boolean isArray;
        private final String normalizedTypeName;
        private final boolean optional;
        private String[] typeModifiers = new String[0];

        public TypeMetadataImpl(String columnName, String typeWithModifiers, boolean optional) {
            boolean isArray;
            this.optional = optional;
            Matcher m = TYPE_PATTERN.matcher(typeWithModifiers);
            if (!m.matches()) {
                LOGGER.error("Failed to parse columnType for {} '{}'", (Object)columnName, (Object)typeWithModifiers);
                throw new ConnectException(String.format("Failed to parse columnType '%s' for column %s", typeWithModifiers, columnName));
            }
            String schema = m.group("schema");
            String fullType = m.group("full");
            String baseType = m.group("base").trim();
            if (!Objects.toString(m.group("suffix"), "").isEmpty()) {
                baseType = String.join((CharSequence)" ", baseType, m.group("suffix").trim());
            }
            if (m.group("mod") != null) {
                this.typeModifiers = TYPEMOD_PATTERN.split(m.group("mod"));
            }
            boolean bl = isArray = m.group("array") != null;
            if (baseType.startsWith("_")) {
                baseType = baseType.substring(1);
                fullType = fullType.substring(1);
                isArray = true;
            }
            String normalizedTypeName = PgOid.normalizeTypeName(baseType);
            if (schema != null) {
                schema = schema.substring(0, schema.length() - 1);
            }
            if (isArray) {
                normalizedTypeName = "_" + normalizedTypeName;
            }
            this.baseType = baseType;
            this.fullType = fullType;
            this.normalizedTypeName = normalizedTypeName;
            this.schema = schema;
            if (this.typeModifiers.length > 0) {
                try {
                    this.length = Integer.parseInt(this.typeModifiers[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.typeModifiers.length > 1) {
                try {
                    this.scale = Integer.parseInt(this.typeModifiers[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.isArray = isArray;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public String getBaseTypeWithSchema() {
            return this.getSchemaPrefix() + this.getBaseType();
        }

        public String getFullType() {
            return this.fullType;
        }

        public String getFullTypeWithSchema() {
            return this.getSchemaPrefix() + this.getFullType();
        }

        @Override
        public OptionalInt getLength() {
            return this.length != null ? OptionalInt.of(this.length) : OptionalInt.empty();
        }

        @Override
        public OptionalInt getScale() {
            return this.scale != null ? OptionalInt.of(this.scale) : OptionalInt.empty();
        }

        public String[] getModifiers() {
            return this.typeModifiers;
        }

        @Override
        public boolean isArray() {
            return this.isArray;
        }

        @Override
        public String getName() {
            return this.normalizedTypeName;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getSchemaPrefix() {
            if (this.schema != null) {
                return this.schema + ".";
            }
            return "";
        }
    }
}

