/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.ChangeEvent;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.TopicSelector;
import io.debezium.data.Envelope;
import io.debezium.relational.TableSchema;
import io.debezium.util.Clock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordsProducer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PostgresTaskContext taskContext;
    protected final SourceInfo sourceInfo;

    protected RecordsProducer(PostgresTaskContext taskContext, SourceInfo sourceInfo) {
        assert (taskContext != null);
        assert (sourceInfo != null);
        this.sourceInfo = sourceInfo;
        this.taskContext = taskContext;
    }

    protected abstract void start(Consumer<ChangeEvent> var1);

    protected abstract void commit(long var1);

    protected abstract void stop();

    protected PostgresSchema schema() {
        return this.taskContext.schema();
    }

    protected TopicSelector topicSelector() {
        return this.taskContext.topicSelector();
    }

    protected Clock clock() {
        return this.taskContext.clock();
    }

    protected Envelope createEnvelope(TableSchema tableSchema, String topicName) {
        return Envelope.defineSchema().withName(this.schema().validateSchemaName(topicName + ".Envelope")).withRecord(tableSchema.valueSchema()).withSource(SourceInfo.SCHEMA).build();
    }
}

