/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.TopicSelector;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.sql.SQLException;

@ThreadSafe
public class PostgresTaskContext {
    private final PostgresConnectorConfig config;
    private final Clock clock;
    private final TopicSelector topicSelector;
    private final PostgresSchema schema;
    private volatile Throwable taskFailure;

    protected PostgresTaskContext(PostgresConnectorConfig config, PostgresSchema schema) {
        this.config = config;
        this.clock = Clock.system();
        this.topicSelector = this.initTopicSelector();
        assert (schema != null);
        this.schema = schema;
    }

    private TopicSelector initTopicSelector() {
        PostgresConnectorConfig.TopicSelectionStrategy topicSelectionStrategy = this.config.topicSelectionStrategy();
        switch (topicSelectionStrategy) {
            case TOPIC_PER_SCHEMA: {
                return TopicSelector.topicPerSchema(this.config.serverName());
            }
            case TOPIC_PER_TABLE: {
                return TopicSelector.topicPerTable(this.config.serverName());
            }
        }
        throw new IllegalArgumentException("Unknown topic selection strategy: " + (Object)((Object)topicSelectionStrategy));
    }

    protected Clock clock() {
        return this.clock;
    }

    protected TopicSelector topicSelector() {
        return this.topicSelector;
    }

    protected PostgresSchema schema() {
        return this.schema;
    }

    protected PostgresConnectorConfig config() {
        return this.config;
    }

    protected void refreshSchema(boolean printReplicaIdentityInfo) throws SQLException {
        try (PostgresConnection connection = this.createConnection();){
            this.schema.refresh(connection, printReplicaIdentityInfo);
        }
    }

    protected ReplicationConnection createReplicationConnection() throws SQLException {
        return ReplicationConnection.builder(this.config.jdbcConfig()).withSlot(this.config.slotName()).withPlugin(this.config.plugin()).dropSlotOnClose(this.config.dropSlotOnStop()).statusUpdateIntervalMillis(this.config.statusUpdateIntervalMillis()).build();
    }

    protected PostgresConnection createConnection() {
        return new PostgresConnection(this.config.jdbcConfig());
    }

    protected LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector((String)"Postgres", (String)this.config.serverName(), (String)contextName);
    }

    Throwable getTaskFailure() {
        return this.taskFailure;
    }

    void failTask(Throwable taskFailure) {
        this.taskFailure = taskFailure;
    }

    PostgresConnectorConfig getConfig() {
        return this.config;
    }
}

