/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.RecordsProducer;
import io.debezium.connector.postgresql.RecordsSnapshotProducer;
import io.debezium.connector.postgresql.RecordsStreamProducer;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Metronome;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorTask
extends SourceTask {
    private static final String CONTEXT_NAME = "postgres-connector-task";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicBoolean running = new AtomicBoolean(false);
    private PostgresTaskContext taskContext;
    private BlockingQueue<SourceRecord> queue;
    private int maxBatchSize;
    private RecordsProducer producer;
    private Metronome metronome;

    public void start(Map<String, String> props) {
        if (this.running.get()) {
            return;
        }
        if (this.context == null) {
            throw new ConnectException("Unexpected null context");
        }
        PostgresConnectorConfig config = new PostgresConnectorConfig(Configuration.from(props));
        if (!config.validateAndRecord(arg_0 -> ((Logger)this.logger).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        PostgresSchema schema = new PostgresSchema(config);
        this.taskContext = new PostgresTaskContext(config, schema);
        this.queue = new LinkedBlockingDeque<SourceRecord>(config.maxQueueSize());
        this.maxBatchSize = config.maxBatchSize();
        SourceInfo sourceInfo = new SourceInfo(config.serverName());
        Map existingOffset = this.context.offsetStorageReader().offset(sourceInfo.partition());
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            try (PostgresConnection connection = this.taskContext.createConnection();){
                this.logger.info(connection.serverInfo().toString());
            }
            if (existingOffset == null) {
                this.logger.info("No previous offset found");
                if (config.snapshotNeverAllowed()) {
                    this.logger.info("Snapshots are not allowed as per configuration, starting streaming logical changes only");
                    this.producer = new RecordsStreamProducer(this.taskContext, sourceInfo);
                } else {
                    this.createSnapshotProducer(this.taskContext, sourceInfo, config.initialOnlySnapshot());
                }
            } else {
                sourceInfo.load(existingOffset);
                this.logger.info("Found previous offset {}", (Object)sourceInfo);
                if (sourceInfo.isSnapshotInEffect()) {
                    if (config.snapshotNeverAllowed()) {
                        String msg = "The connector previously stopped while taking a snapshot, but now the connector is configured to never allow snapshots. Reconfigure the connector to use snapshots initially or when needed.";
                        throw new ConnectException(msg);
                    }
                    this.logger.info("Found previous incomplete snapshot");
                    this.createSnapshotProducer(this.taskContext, sourceInfo, config.initialOnlySnapshot());
                } else if (config.alwaysTakeSnapshot()) {
                    this.logger.info("Taking a new snapshot as per configuration");
                    this.producer = new RecordsSnapshotProducer(this.taskContext, sourceInfo, true);
                } else {
                    this.logger.info("Previous snapshot has completed successfully, streaming logical changes from last known position");
                    this.producer = new RecordsStreamProducer(this.taskContext, sourceInfo);
                }
            }
            this.metronome = Metronome.sleeper((long)config.pollIntervalMs(), (TimeUnit)TimeUnit.MILLISECONDS, (Clock)Clock.SYSTEM);
            this.producer.start(this::enqueueRecord);
            this.running.compareAndSet(false, true);
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
        finally {
            previousContext.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueRecord(SourceRecord record) {
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            this.queue.put(record);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Placed source record '{}' into queue", (Object)record);
            }
        }
        catch (InterruptedException e) {
            this.logger.debug("received interrupt request");
            Thread.interrupted();
        }
        finally {
            previousContext.restore();
        }
    }

    private void createSnapshotProducer(PostgresTaskContext taskContext, SourceInfo sourceInfo, boolean initialOnlySnapshot) {
        if (initialOnlySnapshot) {
            this.logger.info("Taking only a snapshot of the DB without streaming any changes afterwards...");
            this.producer = new RecordsSnapshotProducer(taskContext, sourceInfo, false);
        } else {
            this.logger.info("Taking a new snapshot of the DB and streaming logical changes once the snapshot is finished...");
            this.producer = new RecordsSnapshotProducer(taskContext, sourceInfo, true);
        }
    }

    public void commit() throws InterruptedException {
        this.producer.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SourceRecord> poll() throws InterruptedException {
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            this.logger.debug("polling records...");
            ArrayList<SourceRecord> records = new ArrayList<SourceRecord>();
            while (this.running.get() && this.queue.drainTo(records, this.maxBatchSize) == 0) {
                if (this.taskContext.getTaskFailure() != null) {
                    throw new ConnectException(this.taskContext.getTaskFailure());
                }
                try {
                    this.logger.debug("no records available yet, sleeping a bit...");
                    this.metronome.pause();
                    this.logger.debug("checking for more records...");
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
            ArrayList<SourceRecord> arrayList = records;
            return arrayList;
        }
        finally {
            previousContext.restore();
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.producer.stop();
        }
    }

    public String version() {
        return Module.version();
    }
}

