/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcValueConverters;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;

public class PostgresConnectorConfig {
    protected static final String DATABASE_CONFIG_PREFIX = "database.";
    protected static final int DEFAULT_PORT = 5432;
    protected static final int DEFAULT_MAX_BATCH_SIZE = 10240;
    protected static final int DEFAULT_MAX_QUEUE_SIZE = 20480;
    protected static final int DEFAULT_ROWS_FETCH_SIZE = 10240;
    protected static final long DEFAULT_POLL_INTERVAL_MILLIS = 500L;
    protected static final long DEFAULT_SNAPSHOT_LOCK_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final String TABLE_WHITELIST_NAME = "table.whitelist";
    public static final Field PLUGIN_NAME = Field.create((String)"plugin.name").withDisplayName("Plugin").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("decoderbufs").withDescription("The name of the Postgres logical decoding plugin installed on the server. Defaults to 'decoderbufs'");
    public static final Field SLOT_NAME = Field.create((String)"slot.name").withDisplayName("Slot").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("debezium").withDescription("The name of the Postgres logical decoding slot created for streaming changes from a plugin.Defaults to 'debezium");
    public static final Field DROP_SLOT_ON_STOP = Field.create((String)"slot.drop_on_stop").withDisplayName("Drop slot on stop").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether or not to drop the logical replication slot when the connector finishes orderlyBy default the replication is kept so that on restart progress can resume from the last recorded location");
    public static final Field HOSTNAME = Field.create((String)("database." + JdbcConfiguration.HOSTNAME)).withDisplayName("Hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Resolvable hostname or IP address of the Postgres database server.");
    public static final Field PORT = Field.create((String)("database." + JdbcConfiguration.PORT)).withDisplayName("Port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(5432).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Port of the Postgres database server.");
    public static final Field USER = Field.create((String)("database." + JdbcConfiguration.USER)).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Name of the Postgres database user to be used when connecting to the database.");
    public static final Field PASSWORD = Field.create((String)("database." + JdbcConfiguration.PASSWORD)).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Password of the Postgres database user to be used when connecting to the database.");
    public static final Field DATABASE_NAME = Field.create((String)("database." + JdbcConfiguration.DATABASE)).withDisplayName("Database").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("The name of the database the connector should be monitoring");
    public static final Field SERVER_NAME = Field.create((String)"database.server.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Unique name that identifies the database server and all recorded offsets, andthat is used as a prefix for all schemas and topics. Each distinct Postgres installation should have a separate namespace and monitored by at most one Debezium connector. Defaults to 'host:port/database'");
    public static final Field TOPIC_SELECTION_STRATEGY = Field.create((String)"topic.selection.strategy").withDisplayName("Topic selection strategy").withEnum(TopicSelectionStrategy.class, (Enum)TopicSelectionStrategy.TOPIC_PER_TABLE).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("How events received from the DB should be placed on topics. Options include'table' (the default) each DB table will have a separate Kafka topic; 'schema' there will be one Kafka topic per DB schema; events from multiple topics belonging to the same schema will be placed on the same topic");
    public static final Field MAX_QUEUE_SIZE = Field.create((String)"max.queue.size").withDisplayName("Change event buffer size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 20480, and should always be larger than the maximum batch size.").withDefault(20480).withValidation(new Field.Validator[]{PostgresConnectorConfig::validateMaxQueueSize});
    public static final Field MAX_BATCH_SIZE = Field.create((String)"max.batch.size").withDisplayName("Change event batch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of each batch of source records. Defaults to 10240.").withDefault(10240).withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field ROWS_FETCH_SIZE = Field.create((String)"rows.fetch.size").withDisplayName("Result set fetch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum number of DB rows that should be loaded into memory while performing a snapshot").withDefault(10240).withValidation(new Field.Validator[]{Field::isPositiveLong});
    public static final Field POLL_INTERVAL_MS = Field.create((String)"poll.interval.ms").withDisplayName("Poll interval (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 0.5 second (500 ms).").withDefault(500L).withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field SSL_MODE = Field.create((String)"database.sslmode").withDisplayName("SSL mode").withEnum(SecureConnectionMode.class, (Enum)SecureConnectionMode.DISABLED).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether to use an encrypted connection to Postgres. Options include'disabled' (the default) to use an unencrypted connection; 'required' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify_ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or'verify_full' like 'verify_ca' but additionally verify that the server certificate matches the host to which the connection is attempted.");
    public static final Field SSL_CLIENT_CERT = Field.create((String)"database.sslcert").withDisplayName("SSL Client Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL Certificate for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY = Field.create((String)"database.sslkey").withDisplayName("SSL Client Key").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL private key for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY_PASSWORD = Field.create((String)"database.sslpassword").withDisplayName("SSL Client Key Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Password to access the client private key from the file specified by 'database.sslkey'. See the Postgres SSL docs for further information");
    public static final Field SSL_ROOT_CERT = Field.create((String)"database.sslrootcert").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the root certificate(s) against which the server is validated. See the Postgres JDBC SSL docs for further information");
    public static final Field SSL_SOCKET_FACTORY = Field.create((String)"database.sslfactory").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("A name of class to that creates SSL Sockets. Use org.postgresql.ssl.NonValidatingFactory to disable SSL validation in development environments");
    public static final Field SCHEMA_WHITELIST = Field.create((String)"schema.whitelist").withDisplayName("Schemas").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDependents(new String[]{"table.whitelist"}).withDescription("The schemas for which events should be captured");
    public static final Field SCHEMA_BLACKLIST = Field.create((String)"schema.blacklist").withDisplayName("Exclude Schemas").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{PostgresConnectorConfig::validateSchemaBlacklist}).withInvisibleRecommender().withDescription("");
    public static final Field TABLE_WHITELIST = Field.create((String)"table.whitelist").withDisplayName("Tables").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("The tables for which changes are to be captured");
    public static final Field TABLE_BLACKLIST = Field.create((String)"table.blacklist").withDisplayName("Exclude Tables").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex, PostgresConnectorConfig::validateTableBlacklist}).withInvisibleRecommender();
    public static final Field COLUMN_BLACKLIST = Field.create((String)"column.blacklist").withDisplayName("Exclude Columns").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("");
    public static final Field INCLUDE_SCHEMA_CHANGES = Field.create((String)"include.schema.changes").withDisplayName("Include database schema changes").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether the connector should publish changes in the database schema to a Kafka topic with the same name as the database server name.The default is 'false' because atm this feature is not supported by Postgres logical decoding").withDefault(false);
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'always' to specify that the connector run a snapshot each time it starts up; 'initial' (the default) to specify the connector can run a snapshot only when no offsets are available for the logical server name; 'initial_only' same as 'initial' except the connector should stop after completing the snapshot and before it would normally start emitting changes; and'never' to specify the connector should never run a snapshot and that upon first startup the connector should read from the last position (LSN) recorded by the server");
    public static final Field SNAPSHOT_LOCK_TIMEOUT_MS = Field.create((String)"snapshot.lock.timeout.ms").withDisplayName("Snapshot lock timeout (ms)").withWidth(ConfigDef.Width.LONG).withType(ConfigDef.Type.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDefault(DEFAULT_SNAPSHOT_LOCK_TIMEOUT_MILLIS).withDescription("The maximum number of millis to wait for table locks at the beginning of a snapshot. If locks cannot be acquired in this time frame, the snapshot will be aborted. Defaults to 10 seconds");
    public static final Field TIME_PRECISION_MODE = Field.create((String)"time.precision.mode").withDisplayName("Time Precision").withEnum(TemporalPrecisionMode.class, (Enum)TemporalPrecisionMode.ADAPTIVE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Time, date, and timestamps can be represented with different kinds of precisions, including:'adaptive' (the default) bases the precision of time, date, and timestamp values on the database column's precision; 'connect' always represents time, date, and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision .");
    public static final Field DECIMAL_HANDLING_MODE = Field.create((String)"decimal.handling.mode").withDisplayName("Decimal Handling").withEnum(DecimalHandlingMode.class, (Enum)DecimalHandlingMode.PRECISE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.");
    public static final Field STATUS_UPDATE_INTERVAL_MS = Field.create((String)"status.update.interval.ms").withDisplayName("Status update interval (ms)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Frequency in milliseconds for sending replication connection status updates to the server. Defaults to 10 seconds (10000 ms).").withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field TCP_KEEPALIVE = Field.create((String)"database.tcpKeepAlive").withDisplayName("TCP keep-alive probe").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Enable or disable TCP keep-alive probe to avoid dropping TCP connection").withValidation(new Field.Validator[]{Field::isBoolean});
    public static Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{PLUGIN_NAME, SLOT_NAME, DROP_SLOT_ON_STOP, DATABASE_NAME, USER, PASSWORD, HOSTNAME, PORT, SERVER_NAME, TOPIC_SELECTION_STRATEGY, MAX_BATCH_SIZE, MAX_QUEUE_SIZE, POLL_INTERVAL_MS, SCHEMA_WHITELIST, SCHEMA_BLACKLIST, TABLE_WHITELIST, TABLE_BLACKLIST, COLUMN_BLACKLIST, SNAPSHOT_MODE, TIME_PRECISION_MODE, DECIMAL_HANDLING_MODE, SSL_MODE, SSL_CLIENT_CERT, SSL_CLIENT_KEY_PASSWORD, SSL_ROOT_CERT, SSL_CLIENT_KEY, SNAPSHOT_LOCK_TIMEOUT_MS, ROWS_FETCH_SIZE, SSL_SOCKET_FACTORY, STATUS_UPDATE_INTERVAL_MS, TCP_KEEPALIVE});
    private final Configuration config;
    private final String serverName;
    private final boolean adaptiveTimePrecision;
    private final JdbcValueConverters.DecimalMode decimalHandlingMode;
    private final SnapshotMode snapshotMode;

    protected PostgresConnectorConfig(Configuration config) {
        this.config = config;
        String serverName = config.getString(SERVER_NAME);
        if (serverName == null) {
            serverName = this.hostname() + ":" + this.port() + "/" + this.databaseName();
        }
        this.serverName = serverName;
        TemporalPrecisionMode timePrecisionMode = TemporalPrecisionMode.parse(config.getString(TIME_PRECISION_MODE));
        this.adaptiveTimePrecision = TemporalPrecisionMode.ADAPTIVE == timePrecisionMode;
        String decimalHandlingModeStr = config.getString(DECIMAL_HANDLING_MODE);
        DecimalHandlingMode decimalHandlingMode = DecimalHandlingMode.parse(decimalHandlingModeStr);
        this.decimalHandlingMode = decimalHandlingMode.asDecimalMode();
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
    }

    protected String hostname() {
        return this.config.getString(HOSTNAME);
    }

    protected int port() {
        return this.config.getInteger(PORT);
    }

    protected String databaseName() {
        return this.config.getString(DATABASE_NAME);
    }

    protected String pluginName() {
        return this.config.getString(PLUGIN_NAME);
    }

    protected String slotName() {
        return this.config.getString(SLOT_NAME);
    }

    protected boolean dropSlotOnStop() {
        return this.config.getBoolean(DROP_SLOT_ON_STOP);
    }

    protected Integer statusUpdateIntervalMillis() {
        return this.config.getInteger(STATUS_UPDATE_INTERVAL_MS, null);
    }

    protected int maxQueueSize() {
        return this.config.getInteger(MAX_QUEUE_SIZE);
    }

    protected int maxBatchSize() {
        return this.config.getInteger(MAX_BATCH_SIZE);
    }

    protected long pollIntervalMs() {
        return this.config.getLong(POLL_INTERVAL_MS);
    }

    protected boolean adaptiveTimePrecision() {
        return this.adaptiveTimePrecision;
    }

    protected JdbcValueConverters.DecimalMode decimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    protected Configuration jdbcConfig() {
        return this.config.subset(DATABASE_CONFIG_PREFIX, true);
    }

    protected String serverName() {
        return this.serverName;
    }

    protected TopicSelectionStrategy topicSelectionStrategy() {
        return TopicSelectionStrategy.TOPIC_PER_TABLE;
    }

    protected Map<String, ConfigValue> validate() {
        return this.config.validate(ALL_FIELDS);
    }

    protected boolean validateAndRecord(Consumer<String> errorConsumer) {
        return this.config.validateAndRecord((Iterable)ALL_FIELDS, errorConsumer);
    }

    protected String schemaBlacklist() {
        return this.config.getString(SCHEMA_BLACKLIST);
    }

    protected String schemaWhitelist() {
        return this.config.getString(SCHEMA_WHITELIST);
    }

    protected String tableBlacklist() {
        return this.config.getString(TABLE_BLACKLIST);
    }

    protected String tableWhitelist() {
        return this.config.getString(TABLE_WHITELIST);
    }

    protected String columnBlacklist() {
        return this.config.getString(COLUMN_BLACKLIST);
    }

    protected int rowsFetchSize() {
        return this.config.getInteger(ROWS_FETCH_SIZE);
    }

    protected long snapshotLockTimeoutMillis() {
        return this.config.getLong(SNAPSHOT_LOCK_TIMEOUT_MS);
    }

    protected boolean snapshotNeverAllowed() {
        return SnapshotMode.NEVER == this.snapshotMode;
    }

    protected boolean alwaysTakeSnapshot() {
        return SnapshotMode.ALWAYS == this.snapshotMode;
    }

    protected boolean initialOnlySnapshot() {
        return SnapshotMode.INITIAL_ONLY == this.snapshotMode;
    }

    protected static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, (String)"Postgres", (Field[])new Field[]{SLOT_NAME, PLUGIN_NAME, SERVER_NAME, DATABASE_NAME, HOSTNAME, PORT, USER, PASSWORD, SSL_MODE, SSL_CLIENT_CERT, SSL_CLIENT_KEY_PASSWORD, SSL_ROOT_CERT, SSL_CLIENT_KEY, DROP_SLOT_ON_STOP, SSL_SOCKET_FACTORY, STATUS_UPDATE_INTERVAL_MS, TCP_KEEPALIVE});
        Field.group((ConfigDef)config, (String)"Events", (Field[])new Field[]{SCHEMA_WHITELIST, SCHEMA_BLACKLIST, TABLE_WHITELIST, TABLE_BLACKLIST, COLUMN_BLACKLIST});
        Field.group((ConfigDef)config, (String)"Connector", (Field[])new Field[]{TOPIC_SELECTION_STRATEGY, POLL_INTERVAL_MS, MAX_BATCH_SIZE, MAX_QUEUE_SIZE, SNAPSHOT_MODE, SNAPSHOT_LOCK_TIMEOUT_MS, TIME_PRECISION_MODE, DECIMAL_HANDLING_MODE, ROWS_FETCH_SIZE});
        return config;
    }

    private static int validateMaxQueueSize(Configuration config, Field field, Field.ValidationOutput problems) {
        int maxQueueSize = config.getInteger(field);
        int maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        int count = 0;
        if (maxQueueSize <= 0) {
            problems.accept(field, (Object)maxQueueSize, "A positive queue size is required");
            ++count;
        }
        if (maxQueueSize <= maxBatchSize) {
            problems.accept(field, (Object)maxQueueSize, "Must be larger than the maximum batch size");
            ++count;
        }
        return count;
    }

    private static int validateSchemaBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(SCHEMA_WHITELIST);
        String blacklist = config.getString(SCHEMA_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(SCHEMA_BLACKLIST, (Object)blacklist, "Schema whitelist is already specified");
            return 1;
        }
        return 0;
    }

    private static int validateTableBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(TABLE_WHITELIST);
        String blacklist = config.getString(TABLE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(TABLE_BLACKLIST, (Object)blacklist, "Table whitelist is already specified");
            return 1;
        }
        return 0;
    }

    public static enum TopicSelectionStrategy implements EnumeratedValue
    {
        TOPIC_PER_TABLE("topic_per_table"),
        TOPIC_PER_SCHEMA("topic_per_schema");

        private String value;

        public String getValue() {
            return this.value;
        }

        private TopicSelectionStrategy(String value) {
            this.value = value;
        }

        public static TopicSelectionStrategy parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (TopicSelectionStrategy option : TopicSelectionStrategy.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum SecureConnectionMode implements EnumeratedValue
    {
        DISABLED("disable"),
        REQUIRED("require"),
        VERIFY_CA("verify_ca"),
        VERIFY_FULL("verify_full");

        private final String value;

        private SecureConnectionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SecureConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SecureConnectionMode option : SecureConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SecureConnectionMode parse(String value, String defaultValue) {
            SecureConnectionMode mode = SecureConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SecureConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always"),
        INITIAL("initial"),
        NEVER("never"),
        INITIAL_ONLY("initial_only");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum DecimalHandlingMode implements EnumeratedValue
    {
        PRECISE("precise"),
        DOUBLE("double");

        private final String value;

        private DecimalHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public JdbcValueConverters.DecimalMode asDecimalMode() {
            switch (this) {
                case DOUBLE: {
                    return JdbcValueConverters.DecimalMode.DOUBLE;
                }
            }
            return JdbcValueConverters.DecimalMode.PRECISE;
        }

        public static DecimalHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (DecimalHandlingMode option : DecimalHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static DecimalHandlingMode parse(String value, String defaultValue) {
            DecimalHandlingMode mode = DecimalHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = DecimalHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum TemporalPrecisionMode implements EnumeratedValue
    {
        ADAPTIVE("adaptive"),
        CONNECT("connect");

        private final String value;

        private TemporalPrecisionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static TemporalPrecisionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (TemporalPrecisionMode option : TemporalPrecisionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static TemporalPrecisionMode parse(String value, String defaultValue) {
            TemporalPrecisionMode mode = TemporalPrecisionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = TemporalPrecisionMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

