/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.docstring;

import io.cucumber.docstring.CucumberDocStringException;
import io.cucumber.docstring.DocStringType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DocStringTypeRegistry {
    private static final Class<String> DEFAULT_TYPE = String.class;
    private static final String DEFAULT_CONTENT_TYPE = "";
    private final Map<String, Map<Type, DocStringType>> docStringTypes = new HashMap<String, Map<Type, DocStringType>>();

    public DocStringTypeRegistry() {
        this.defineDocStringType(new DocStringType(DEFAULT_TYPE, DEFAULT_CONTENT_TYPE, docString -> docString));
    }

    public void defineDocStringType(DocStringType docStringType) {
        DocStringType existing = this.lookupByContentTypeAndType(docStringType.getContentType(), docStringType.getType());
        if (existing != null) {
            throw DocStringTypeRegistry.createDuplicateTypeException(existing, docStringType);
        }
        Map map = this.docStringTypes.computeIfAbsent(docStringType.getContentType(), s -> new HashMap());
        map.put(docStringType.getType(), docStringType);
        this.docStringTypes.put(docStringType.getContentType(), map);
    }

    private static CucumberDocStringException createDuplicateTypeException(DocStringType existing, DocStringType docStringType) {
        String contentType = existing.getContentType();
        return new CucumberDocStringException(String.format("There is already docstring type registered for '%s' and %s.\nYou are trying to add '%s' and %s", DocStringTypeRegistry.emptyToAnonymous(contentType), existing.getType().getTypeName(), DocStringTypeRegistry.emptyToAnonymous(docStringType.getContentType()), docStringType.getType().getTypeName()));
    }

    private static String emptyToAnonymous(String contentType) {
        return contentType.isEmpty() ? "[anonymous]" : contentType;
    }

    List<DocStringType> lookup(String contentType, Type type) {
        if (contentType == null) {
            return this.lookUpByType(type);
        }
        DocStringType docStringType = this.lookupByContentTypeAndType(contentType, type);
        if (docStringType == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(docStringType);
    }

    private List<DocStringType> lookUpByType(Type type) {
        return this.docStringTypes.values().stream().flatMap(typeDocStringTypeMap -> typeDocStringTypeMap.entrySet().stream().filter(entry -> ((Type)entry.getKey()).equals(type)).map(Map.Entry::getValue)).collect(Collectors.toList());
    }

    private DocStringType lookupByContentTypeAndType(String contentType, Type type) {
        Map<Type, DocStringType> docStringTypesByType = this.docStringTypes.get(contentType);
        if (docStringTypesByType == null) {
            return null;
        }
        return docStringTypesByType.get(type);
    }
}

