package io.cucumber.java8;

import io.cucumber.java8.StepDefinitionBody.A0;
import io.cucumber.java8.StepDefinitionBody.A1;
import io.cucumber.java8.StepDefinitionBody.A2;
import io.cucumber.java8.StepDefinitionBody.A3;
import io.cucumber.java8.StepDefinitionBody.A4;
import io.cucumber.java8.StepDefinitionBody.A5;
import io.cucumber.java8.StepDefinitionBody.A6;
import io.cucumber.java8.StepDefinitionBody.A7;
import io.cucumber.java8.StepDefinitionBody.A8;
import io.cucumber.java8.StepDefinitionBody.A9;

import io.cucumber.java8.LambdaGlueRegistry;
import io.cucumber.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Javanese - Basa Jawa
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface Jv extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ananging(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Ananging(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Ananging(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Ananging(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Ananging(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Ananging(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Ananging(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ananging(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ananging(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ananging(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Banjur(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Banjur(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Banjur(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Banjur(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Banjur(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Banjur(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Banjur(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Banjur(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Banjur(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Banjur(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Lan(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Lan(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Lan(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Lan(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Lan(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Lan(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Lan(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Lan(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Lan(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Lan(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Manawa(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Manawa(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Manawa(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Manawa(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Manawa(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Manawa(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Manawa(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Manawa(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Manawa(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Manawa(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Menawa(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Menawa(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Menawa(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Menawa(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Menawa(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Menawa(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Menawa(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Menawa(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Menawa(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Menawa(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nalika(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Nalika(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Nalika(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Nalika(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Nalika(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Nalika(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Nalika(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nalika(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nalika(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nalika(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nalikaning(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Nalikaning(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Nalikaning(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Nalikaning(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Nalikaning(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Nalikaning(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Nalikaning(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nalikaning(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nalikaning(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nalikaning(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nanging(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Nanging(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Nanging(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Nanging(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Nanging(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Nanging(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Nanging(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nanging(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nanging(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nanging(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Njuk(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Njuk(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Njuk(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Njuk(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Njuk(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Njuk(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Njuk(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Njuk(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Njuk(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Njuk(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Tapi(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Tapi(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Tapi(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Tapi(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Tapi(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Tapi(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Tapi(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Tapi(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Tapi(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Tapi(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }

}
