/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.ScenarioScoped;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import net.jodah.typetools.TypeResolver;

abstract class AbstractGlueDefinition
implements ScenarioScoped {
    final Object body;
    final Method method;
    final StackTraceElement location;

    AbstractGlueDefinition(Object body, StackTraceElement location) {
        this.body = Objects.requireNonNull(body);
        this.method = this.getAcceptMethod(body.getClass());
        this.location = Objects.requireNonNull(location);
    }

    private Method getAcceptMethod(Class<?> bodyClass) {
        ArrayList<Method> acceptMethods = new ArrayList<Method>();
        for (Method method : bodyClass.getDeclaredMethods()) {
            if (method.isBridge() || method.isSynthetic() || !"accept".equals(method.getName())) continue;
            acceptMethods.add(method);
        }
        if (acceptMethods.size() != 1) {
            throw new IllegalStateException(String.format("Expected single 'accept' method on body class, found '%s'", acceptMethods));
        }
        return (Method)acceptMethods.get(0);
    }

    public final String getLocation() {
        return this.location.toString();
    }

    public final boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName() != null && this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    Class<?>[] resolveRawArguments(Class<?> bodyClass, Class<?> body) {
        Class[] rawArguments;
        for (Class aClass : rawArguments = TypeResolver.resolveRawArguments(bodyClass, body)) {
            if (!TypeResolver.Unknown.class.equals((Object)aClass)) continue;
            throw new IllegalStateException("Could resolve the return type of the lambda at " + this.location.getFileName() + ":" + this.location.getLineNumber() + "\nThis version of cucumber-java8 is not compatible with Java 12+\nSee: https://github.com/cucumber/cucumber-jvm/issues/1817");
        }
        return rawArguments;
    }
}

