/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java8;

import cucumber.api.Scenario;
import cucumber.api.java8.HookBody;
import cucumber.api.java8.HookNoArgsBody;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.Timeout;
import cucumber.runtime.filter.TagPredicate;
import gherkin.pickles.PickleTag;
import java.util.Arrays;
import java.util.Collection;

public class Java8HookDefinition
implements HookDefinition {
    private final TagPredicate tagPredicate;
    private final int order;
    private final long timeoutMillis;
    private final HookNoArgsBody hookNoArgsBody;
    private final HookBody hookBody;
    private final StackTraceElement location;

    private Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookBody hookBody, HookNoArgsBody hookNoArgsBody) {
        this.order = order;
        this.timeoutMillis = timeoutMillis;
        this.tagPredicate = new TagPredicate(Arrays.asList(tagExpressions));
        this.hookBody = hookBody;
        this.hookNoArgsBody = hookNoArgsBody;
        this.location = new Exception().getStackTrace()[3];
    }

    public Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookBody hookBody) {
        this(tagExpressions, order, timeoutMillis, hookBody, null);
    }

    public Java8HookDefinition(String[] tagExpressions, int order, long timeoutMillis, HookNoArgsBody hookNoArgsBody) {
        this(tagExpressions, order, timeoutMillis, null, hookNoArgsBody);
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public void execute(Scenario scenario) throws Throwable {
        Timeout.timeout(() -> {
            if (this.hookBody != null) {
                this.hookBody.accept(scenario);
            } else {
                this.hookNoArgsBody.accept();
            }
            return null;
        }, (long)this.timeoutMillis);
    }

    public boolean matches(Collection<PickleTag> tags) {
        return this.tagPredicate.apply(tags);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isScenarioScoped() {
        return true;
    }
}

