/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.commons.services.impl;

import io.cloudslang.lang.api.Slang;
import io.cloudslang.lang.commons.services.api.CompilationHelper;
import io.cloudslang.lang.commons.services.api.SlangCompilationService;
import io.cloudslang.lang.compiler.Extension;
import io.cloudslang.lang.compiler.PrecompileStrategy;
import io.cloudslang.lang.compiler.SlangSource;
import io.cloudslang.lang.compiler.modeller.result.CompilationModellingResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlangCompilationServiceImpl
implements SlangCompilationService {
    private static final Logger logger = LogManager.getLogger(SlangCompilationServiceImpl.class);
    @Autowired
    private Slang slang;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CompilationModellingResult> compileFolders(List<String> foldersPaths, CompilationHelper compilationHelper) {
        ArrayList<CompilationModellingResult> results = new ArrayList<CompilationModellingResult>();
        try {
            Set<SlangSource> dependencySources = this.getSourcesFromFolders(foldersPaths);
            for (SlangSource dependencySource : dependencySources) {
                File file = this.getFile(dependencySource.getFilePath());
                compilationHelper.onEveryFile(file);
                try {
                    CompilationModellingResult result = this.slang.compileSource(dependencySource, dependencySources, PrecompileStrategy.WITH_CACHE);
                    result.setFile(file);
                    results.add(result);
                }
                catch (Exception e) {
                    logger.error("Failed compilation for file : " + file.getName() + " ,Exception is : " + e.getMessage());
                }
            }
        }
        finally {
            compilationHelper.onCompilationFinish();
            this.slang.invalidateAllInPreCompileCache();
        }
        return results;
    }

    @Override
    public File getFile(String filePath) {
        Validate.notNull((Object)filePath, (String)"File path can not be null", (Object[])new Object[0]);
        File file = new File(filePath);
        Validate.isTrue((boolean)file.isFile(), (String)("File: " + file.getName() + " was not found"), (Object[])new Object[0]);
        Extension.validateSlangFileExtension((String)file.getName());
        return file;
    }

    @Override
    public Set<SlangSource> getSourcesFromFolders(List<String> dependencies) {
        HashSet<SlangSource> dependencySources = new HashSet<SlangSource>();
        for (String dependency : dependencies) {
            Collection<File> dependenciesFiles = this.listSlangFiles(new File(dependency), true);
            for (File dependencyCandidate : dependenciesFiles) {
                SlangSource source = SlangSource.fromFile((File)dependencyCandidate);
                dependencySources.add(source);
            }
        }
        return dependencySources;
    }

    @Override
    public Collection<File> listSlangFiles(File directory, boolean recursive) {
        Validate.isTrue((boolean)directory.isDirectory(), (String)("Parameter '" + directory.getPath() + "' is not a directory"), (Object[])new Object[0]);
        return FileUtils.listFiles((File)directory, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return Extension.SL == Extension.findExtension((String)file.getName());
            }

            public boolean accept(File file, String name) {
                return Extension.SL == Extension.findExtension((String)name);
            }
        }, (IOFileFilter)(recursive ? TrueFileFilter.INSTANCE : null));
    }
}

