/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.xml;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.format.EventSerializationException;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.xml.XMLDeserializer;
import io.cloudevents.xml.XMLSerializer;
import io.cloudevents.xml.XMLUtils;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public class XMLFormat
implements EventFormat {
    public static final String XML_CONTENT_TYPE = "application/cloudevents+xml";

    public byte[] serialize(CloudEvent event) throws EventSerializationException {
        Document d = XMLSerializer.toDocument(event);
        try {
            return XMLUtils.documentToBytes(d);
        }
        catch (TransformerException e) {
            throw new EventSerializationException((Throwable)e);
        }
    }

    public CloudEvent deserialize(byte[] bytes, CloudEventDataMapper<? extends CloudEventData> mapper) throws EventDeserializationException {
        Document doc = XMLUtils.parseIntoDocument(bytes);
        return (CloudEvent)new XMLDeserializer(doc).read(CloudEventBuilder::fromSpecVersion);
    }

    public String serializedContentType() {
        return XML_CONTENT_TYPE;
    }
}

