/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.parser;

import io.cloudevents.sql.EvaluationException;
import io.cloudevents.sql.ExceptionFactory;
import io.cloudevents.sql.Expression;
import io.cloudevents.sql.ParseException;
import io.cloudevents.sql.Parser;
import io.cloudevents.sql.generated.CESQLParserLexer;
import io.cloudevents.sql.generated.CESQLParserParser;
import io.cloudevents.sql.impl.ExpressionInternal;
import io.cloudevents.sql.impl.parser.CaseChangingCharStream;
import io.cloudevents.sql.impl.parser.ConstantFoldingExpressionVisitor;
import io.cloudevents.sql.impl.parser.ExpressionTranslatorVisitor;
import io.cloudevents.sql.impl.runtime.ExpressionImpl;
import java.util.ArrayList;
import java.util.BitSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;

public class ParserImpl
implements Parser {
    private final boolean constantFolding;

    public static Parser getInstance() {
        return SingletonContainer.INSTANCE;
    }

    ParserImpl(boolean constantFolding) {
        this.constantFolding = constantFolding;
    }

    @Override
    public Expression parse(String inputExpression) {
        CodePointCharStream s = CharStreams.fromString((String)inputExpression);
        CaseChangingCharStream upperInput = new CaseChangingCharStream((CharStream)s, true);
        CESQLParserLexer lexer = new CESQLParserLexer(upperInput);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CESQLParserParser parser = new CESQLParserParser((TokenStream)tokens);
        final ArrayList parseExceptionList = new ArrayList();
        parser.removeErrorListeners();
        parser.addErrorListener(new ANTLRErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                parseExceptionList.add(ExceptionFactory.recognitionError(e, msg));
            }

            public void reportAmbiguity(org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            }

            public void reportAttemptingFullContext(org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
            }

            public void reportContextSensitivity(org.antlr.v4.runtime.Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            }
        });
        CESQLParserParser.CesqlContext tree = parser.cesql();
        if (!parseExceptionList.isEmpty()) {
            throw (ParseException)parseExceptionList.get(0);
        }
        ExpressionInternal internal = (ExpressionInternal)new ExpressionTranslatorVisitor().visit((ParseTree)tree);
        if (this.constantFolding) {
            try {
                internal = internal.visit(new ConstantFoldingExpressionVisitor());
            }
            catch (EvaluationException e) {
                throw ExceptionFactory.cannotEvaluateConstantExpression(e);
            }
        }
        return new ExpressionImpl(internal);
    }

    private static class SingletonContainer {
        private static final ParserImpl INSTANCE = new ParserImpl(true);

        private SingletonContainer() {
        }
    }
}

