/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.functions;

import io.cloudevents.sql.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class BaseFunction
implements Function {
    private final String name;

    protected BaseFunction(String name) {
        this.name = name.toUpperCase();
    }

    @Override
    public String name() {
        return this.name;
    }

    protected void requireValidParameterIndex(int i) {
        if (!this.isVariadic() && i >= this.arity()) {
            throw new IllegalArgumentException("The provided index must less than the arity of the function: " + i + " < " + this.arity());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name());
        builder.append('(');
        if (this.arity() > 0) {
            builder.append(IntStream.range(0, this.arity()).mapToObj(i -> this.typeOfParameter(i).name()).collect(Collectors.joining(",")));
            if (this.isVariadic()) {
                builder.append(", ").append((Object)this.typeOfParameter(this.arity())).append("...");
            }
        }
        builder.append(')');
        return builder.toString();
    }
}

