/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql;

import io.cloudevents.sql.EvaluationException;
import io.cloudevents.sql.Type;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class ParseException
extends RuntimeException {
    private final ErrorKind errorKind;
    private final Interval interval;
    private final String expression;

    protected ParseException(ErrorKind errorKind, Interval interval, String expression, String message, Throwable cause) {
        super(String.format("[%s at %d:%d `%s`] %s", errorKind.name(), interval.a, interval.b, expression, message), cause);
        this.errorKind = errorKind;
        this.interval = interval;
        this.expression = expression;
    }

    public ErrorKind getKind() {
        return this.errorKind;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public String getExpression() {
        return this.expression;
    }

    public static ParseException cannotParseValue(ParseTree node, Type target, Throwable cause) {
        return new ParseException(ErrorKind.PARSE_VALUE, node.getSourceInterval(), node.getText(), "Cannot parse to " + target.name() + ": " + cause.getMessage(), cause);
    }

    public static ParseException recognitionError(RecognitionException e, String msg) {
        return new ParseException(ErrorKind.RECOGNITION, new Interval(e.getOffendingToken().getStartIndex(), e.getOffendingToken().getStopIndex()), e.getOffendingToken().getText(), "Cannot parse: " + msg, e);
    }

    public static ParseException cannotEvaluateConstantExpression(EvaluationException exception) {
        return new ParseException(ErrorKind.CONSTANT_EXPRESSION_EVALUATION, exception.getExpressionInterval(), exception.getExpressionText(), "Cannot evaluate the constant expression: " + exception.getExpressionText(), exception);
    }

    public static enum ErrorKind {
        RECOGNITION,
        PARSE_VALUE,
        CONSTANT_EXPRESSION_EVALUATION;

    }
}

