/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.expressions;

import io.cloudevents.CloudEvent;
import io.cloudevents.sql.EvaluationRuntime;
import io.cloudevents.sql.Type;
import io.cloudevents.sql.impl.EvaluationContextImpl;
import io.cloudevents.sql.impl.ExceptionThrower;
import io.cloudevents.sql.impl.ExpressionInternal;
import io.cloudevents.sql.impl.expressions.BaseExpression;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.misc.Interval;

public class InExpression
extends BaseExpression {
    private final ExpressionInternal leftExpression;
    private final List<ExpressionInternal> setExpressions;

    public InExpression(Interval expressionInterval, String expressionText, ExpressionInternal leftExpression, List<ExpressionInternal> setExpressions) {
        super(expressionInterval, expressionText);
        this.leftExpression = leftExpression;
        this.setExpressions = setExpressions;
    }

    @Override
    public Object evaluate(EvaluationRuntime runtime, CloudEvent event, ExceptionThrower thrower) {
        Object leftValue = this.leftExpression.evaluate(runtime, event, thrower);
        return this.setExpressions.stream().anyMatch(expr -> {
            Object rightValue = runtime.cast(new EvaluationContextImpl(this.expressionInterval(), this.expressionText(), thrower), expr.evaluate(runtime, event, thrower), Type.fromValue(leftValue));
            return Objects.equals(leftValue, rightValue);
        });
    }
}

