/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql;

import org.antlr.v4.runtime.misc.Interval;

public class EvaluationException
extends RuntimeException {
    private final ErrorKind errorKind;
    private final Interval interval;
    private final String expression;

    protected EvaluationException(ErrorKind errorKind, Interval interval, String expression, String message, Throwable cause) {
        super(String.format("%s at %s `%s`: %s", errorKind.name(), interval.toString(), expression, message), cause);
        this.errorKind = errorKind;
        this.interval = interval;
        this.expression = expression;
    }

    public ErrorKind getKind() {
        return this.errorKind;
    }

    public Interval getExpressionInterval() {
        return this.interval;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public static EvaluationExceptionFactory invalidCastTarget(Class<?> from, Class<?> to) {
        return (interval, expression) -> new EvaluationException(ErrorKind.INVALID_CAST, interval, expression, "Cannot cast " + from + " to " + to + ": no cast defined.", null);
    }

    public static EvaluationExceptionFactory castError(Class<?> from, Class<?> to, Throwable cause) {
        return (interval, expression) -> new EvaluationException(ErrorKind.INVALID_CAST, interval, expression, "Cannot cast " + from + " to " + to + ": " + cause.getMessage(), cause);
    }

    public static EvaluationException missingAttribute(Interval interval, String expression, String key) {
        return new EvaluationException(ErrorKind.MISSING_ATTRIBUTE, interval, expression, "Missing attribute " + key + " in the input event. Perhaps you should check with 'EXISTS " + key + "' if the input contains the provided key?", null);
    }

    public static EvaluationException cannotDispatchFunction(Interval interval, String expression, String functionName, Throwable cause) {
        return new EvaluationException(ErrorKind.FUNCTION_DISPATCH, interval, expression, "Cannot dispatch function invocation to function " + functionName + ": " + cause.getMessage(), cause);
    }

    public static EvaluationExceptionFactory functionExecutionError(String functionName, Throwable cause) {
        return (interval, expression) -> new EvaluationException(ErrorKind.FUNCTION_EXECUTION, interval, expression, "Error while executing " + functionName + ": " + cause.getMessage(), cause);
    }

    public static EvaluationException divisionByZero(Interval interval, String expression, Integer dividend) {
        return new EvaluationException(ErrorKind.MATH, interval, expression, "Division by zero: " + dividend + " / 0", null);
    }

    public static enum ErrorKind {
        INVALID_CAST,
        MISSING_ATTRIBUTE,
        FUNCTION_DISPATCH,
        FUNCTION_EXECUTION,
        MATH;

    }

    @FunctionalInterface
    public static interface EvaluationExceptionFactory {
        public EvaluationException create(Interval var1, String var2);
    }
}

