/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.vertx.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.http.vertx.impl.CloudEventsHeaders;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;

public class VertxHttpClientRequestMessageWriterImpl
implements MessageWriter<CloudEventWriter<HttpClientRequest>, HttpClientRequest>,
CloudEventWriter<HttpClientRequest> {
    private final HttpClientRequest request;

    public VertxHttpClientRequestMessageWriterImpl(HttpClientRequest request) {
        this.request = request;
    }

    public CloudEventWriter<HttpClientRequest> create(SpecVersion version) {
        this.request.putHeader(CloudEventsHeaders.SPEC_VERSION, (CharSequence)version.toString());
        return this;
    }

    public void setAttribute(String name, String value) throws CloudEventRWException {
        this.request.putHeader(CloudEventsHeaders.ATTRIBUTES_TO_HEADERS.get(name), (CharSequence)value);
    }

    public void setExtension(String name, String value) throws CloudEventRWException {
        this.request.putHeader("ce-" + name, value);
    }

    public HttpClientRequest end(byte[] value) throws CloudEventRWException {
        this.request.end(Buffer.buffer((byte[])value));
        return this.request;
    }

    public HttpClientRequest end() {
        this.request.end();
        return this.request;
    }

    public HttpClientRequest setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.request.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)format.serializedContentType());
        this.request.end(Buffer.buffer((byte[])value));
        return this.request;
    }
}

