/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.extensions.InMemoryFormat;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventBuilder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class CloudEventImpl<T>
implements CloudEvent<AttributesImpl, T> {
    @NotNull
    @JsonIgnore
    private final AttributesImpl attributes;
    private final T data;
    private final byte[] dataBase64;
    @NotNull
    private final Map<String, Object> extensions;
    private final Set<ExtensionFormat> extensionsFormats;

    CloudEventImpl(AttributesImpl attributes, byte[] dataBase64, Set<ExtensionFormat> extensions) {
        this(attributes, extensions, null, dataBase64);
    }

    CloudEventImpl(AttributesImpl attributes, T data, Set<ExtensionFormat> extensions) {
        this(attributes, extensions, data, null);
    }

    private CloudEventImpl(AttributesImpl attributes, Set<ExtensionFormat> extensions, T data, byte[] dataBase64) {
        this.attributes = attributes;
        this.extensions = extensions.stream().map(ExtensionFormat::memory).collect(Collectors.toMap(InMemoryFormat::getKey, InMemoryFormat::getValue));
        this.data = data;
        this.dataBase64 = dataBase64;
        this.extensionsFormats = extensions;
    }

    Set<ExtensionFormat> getExtensionsFormats() {
        return this.extensionsFormats;
    }

    @Override
    @JsonUnwrapped
    public AttributesImpl getAttributes() {
        return this.attributes;
    }

    @Override
    public Optional<T> getData() {
        return Optional.ofNullable(this.data);
    }

    @Override
    @JsonProperty(value="data_base64")
    public byte[] getDataBase64() {
        return this.dataBase64;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @JsonAnySetter
    void addExtension(String name, Object value) {
        this.extensions.put(name, value);
    }

    @JsonCreator
    public static <T> CloudEventImpl<T> build(@JsonProperty(value="id") String id, @JsonProperty(value="source") URI source, @JsonProperty(value="type") String type, @JsonProperty(value="datacontenttype") String datacontenttype, @JsonProperty(value="dataschema") URI dataschema, @JsonProperty(value="subject") String subject, @JsonProperty(value="time") ZonedDateTime time, @JsonProperty(value="data") T data, @JsonProperty(value="data_base64") byte[] dataBase64) {
        return CloudEventBuilder.builder().withId(id).withSource(source).withType(type).withTime(time).withDataschema(dataschema).withDataContentType(datacontenttype).withData(data).withDataBase64(dataBase64).withSubject(subject).build();
    }
}

