/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v03;

import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.fun.EventBuilder;
import io.cloudevents.v03.Accessor;
import io.cloudevents.v03.AttributesImpl;
import io.cloudevents.v03.CloudEventImpl;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;

public final class CloudEventBuilder<T>
implements EventBuilder<T, AttributesImpl> {
    private static Validator VALIDATOR;
    public static final String SPEC_VERSION = "0.3";
    private static final String MESSAGE_SEPARATOR = ", ";
    private static final String MESSAGE = "'%s' %s";
    private static final String ERR_MESSAGE = "invalid payload: %s";
    private String id;
    private URI source;
    private String type;
    private ZonedDateTime time;
    private URI schemaurl;
    private String datacontentencoding;
    private String datacontenttype;
    private String subject;
    private T data;
    private final Set<ExtensionFormat> extensions = new HashSet<ExtensionFormat>();
    private Validator validator;

    private CloudEventBuilder() {
    }

    private static Validator getValidator() {
        if (null == VALIDATOR) {
            VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return VALIDATOR;
    }

    public static <T> CloudEventBuilder<T> builder() {
        return new CloudEventBuilder<T>();
    }

    public static <T> CloudEventBuilder<T> builder(CloudEvent<AttributesImpl, T> base) {
        Objects.requireNonNull(base);
        CloudEventBuilder<T> result = new CloudEventBuilder<T>();
        AttributesImpl attributes = base.getAttributes();
        result.withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(result::withTime);
        attributes.getSchemaurl().ifPresent(result::withSchemaurl);
        attributes.getDatacontenttype().ifPresent(result::withDatacontenttype);
        attributes.getDatacontentencoding().ifPresent(result::withDatacontentencoding);
        attributes.getSubject().ifPresent(result::withSubject);
        Accessor.extensionsOf(base).forEach(result::withExtension);
        base.getData().ifPresent(result::withData);
        return result;
    }

    public static <T> CloudEventImpl<T> of(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions) {
        return CloudEventBuilder.of(data, attributes, extensions, null);
    }

    public static <T> CloudEventImpl<T> of(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions, Validator validator) {
        CloudEventBuilder<T> builder = CloudEventBuilder.builder().withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(builder::withTime);
        attributes.getSchemaurl().ifPresent(builder::withSchemaurl);
        attributes.getDatacontentencoding().ifPresent(builder::withDatacontentencoding);
        attributes.getDatacontenttype().ifPresent(builder::withDatacontenttype);
        attributes.getSubject().ifPresent(builder::withSubject);
        extensions.forEach(builder::withExtension);
        return builder.withData(data).withValidator(validator).build();
    }

    @Override
    public CloudEvent<AttributesImpl, T> build(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions) {
        return CloudEventBuilder.of(data, attributes, extensions, this.validator);
    }

    public CloudEventImpl<T> build() {
        AttributesImpl attributes = new AttributesImpl(this.id, this.source, SPEC_VERSION, this.type, this.time, this.schemaurl, this.datacontentencoding, this.datacontenttype, this.subject);
        CloudEventImpl<T> cloudEvent = new CloudEventImpl<T>(attributes, this.data, this.extensions);
        if (this.validator == null) {
            this.validator = CloudEventBuilder.getValidator();
        }
        Set violations = this.validator.validate(cloudEvent, new Class[0]);
        violations.addAll(this.validator.validate((Object)cloudEvent.getAttributes(), new Class[0]));
        String errs = violations.stream().map(v -> String.format(MESSAGE, v.getPropertyPath(), v.getMessage())).collect(Collectors.joining(MESSAGE_SEPARATOR));
        Optional.ofNullable("".equals(errs) ? null : errs).ifPresent(e -> {
            throw new IllegalStateException(String.format(ERR_MESSAGE, e));
        });
        return cloudEvent;
    }

    public CloudEventBuilder<T> withId(String id) {
        this.id = id;
        return this;
    }

    public CloudEventBuilder<T> withSource(URI source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder<T> withType(String type) {
        this.type = type;
        return this;
    }

    public CloudEventBuilder<T> withTime(ZonedDateTime time) {
        this.time = time;
        return this;
    }

    public CloudEventBuilder<T> withSchemaurl(URI schemaurl) {
        this.schemaurl = schemaurl;
        return this;
    }

    public CloudEventBuilder<T> withDatacontentencoding(String datacontentencoding) {
        this.datacontentencoding = datacontentencoding;
        return this;
    }

    public CloudEventBuilder<T> withDatacontenttype(String datacontenttype) {
        this.datacontenttype = datacontenttype;
        return this;
    }

    public CloudEventBuilder<T> withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public CloudEventBuilder<T> withData(T data) {
        this.data = data;
        return this;
    }

    public CloudEventBuilder<T> withExtension(ExtensionFormat extension) {
        this.extensions.add(extension);
        return this;
    }

    public CloudEventBuilder<T> withValidator(Validator validator) {
        this.validator = validator;
        return this;
    }
}

