/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents;

import io.cloudevents.CloudEvent;
import io.cloudevents.impl.DefaultCloudEventImpl;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class CloudEventBuilder<T> {
    private final String cloudEventsVersion = "0.1";
    private Map<?, ?> extensions = new LinkedHashMap();
    private String contentType;
    private String eventType;
    private URI source;
    private String eventID;
    private String eventTypeVersion;
    private ZonedDateTime eventTime;
    private URI schemaURL;
    private T data;

    public CloudEventBuilder<T> eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public CloudEventBuilder<T> eventTypeVersion(String eventTypeVersion) {
        this.eventTypeVersion = eventTypeVersion;
        return this;
    }

    public CloudEventBuilder<T> source(URI source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder<T> eventID(String eventID) {
        this.eventID = eventID;
        return this;
    }

    public CloudEventBuilder<T> eventTime(ZonedDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public CloudEventBuilder<T> schemaURL(URI schemaURL) {
        this.schemaURL = schemaURL;
        return this;
    }

    public CloudEventBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public CloudEventBuilder<T> extensions(Map extensions) {
        this.extensions = extensions;
        return this;
    }

    public CloudEventBuilder<T> data(T data) {
        this.data = data;
        return this;
    }

    public CloudEvent<T> build() {
        if (this.eventType == null || "0.1" == null || this.source == null || this.eventID == null) {
            throw new IllegalArgumentException("please provide all required fields");
        }
        return new DefaultCloudEventImpl<T>(this.eventType, "0.1", this.source, this.eventID, this.eventTypeVersion, this.eventTime, this.schemaURL, this.contentType, this.extensions, this.data);
    }
}

