/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeDeserializer
extends StdDeserializer<ZonedDateTime> {
    public ZonedDateTimeDeserializer() {
        this(null);
    }

    public ZonedDateTimeDeserializer(Class<?> vc) {
        super(vc);
    }

    public ZonedDateTime deserialize(JsonParser jsonparser, DeserializationContext ctxt) throws IOException {
        try {
            return ZonedDateTime.parse(jsonparser.getText(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException("could not parse");
        }
    }
}

