/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.encoding.AuthInfo;
import io.camunda.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.camunda.zeebe.protocol.record.ExecuteCommandRequestEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ExecuteCommandRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ExecuteCommandRequestEncoder bodyEncoder = new ExecuteCommandRequestEncoder();
    private final ExecuteCommandRequestDecoder bodyDecoder = new ExecuteCommandRequestDecoder();
    private final DirectBuffer value = new UnsafeBuffer(0L, 0);
    private int partitionId;
    private long key;
    private long operationReference;
    private ValueType valueType;
    private Intent intent;
    private final AuthInfo authorization = new AuthInfo();

    public ExecuteCommandRequest() {
        this.reset();
    }

    public ExecuteCommandRequest reset() {
        this.partitionId = ExecuteCommandRequestEncoder.partitionIdNullValue();
        this.key = ExecuteCommandRequestEncoder.keyNullValue();
        this.operationReference = ExecuteCommandRequestEncoder.operationReferenceNullValue();
        this.valueType = ValueType.NULL_VAL;
        this.intent = Intent.UNKNOWN;
        this.value.wrap(0L, 0);
        this.authorization.reset();
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ExecuteCommandRequest setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public long getKey() {
        return this.key;
    }

    public ExecuteCommandRequest setKey(long key) {
        this.key = key;
        this.partitionId = Protocol.decodePartitionId((long)key);
        return this;
    }

    public long getOperationReference() {
        return this.operationReference;
    }

    public ExecuteCommandRequest setOperationReference(long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public ExecuteCommandRequest setValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public ExecuteCommandRequest setIntent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public DirectBuffer getValue() {
        return this.value;
    }

    public ExecuteCommandRequest setValue(DirectBuffer buffer, int offset, int length) {
        this.value.wrap(buffer, offset, length);
        return this;
    }

    public AuthInfo getAuthorization() {
        return this.authorization;
    }

    public ExecuteCommandRequest setAuthorization(AuthInfo authorization) {
        this.authorization.wrap(authorization);
        return this;
    }

    public ExecuteCommandRequest setAuthorization(DirectBuffer buffer) {
        this.authorization.wrap(buffer);
        return this;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.partitionId = this.bodyDecoder.partitionId();
        this.key = this.bodyDecoder.key();
        this.operationReference = this.bodyDecoder.operationReference();
        this.valueType = this.bodyDecoder.valueType();
        this.intent = Intent.fromProtocolValue((ValueType)this.valueType, (short)this.bodyDecoder.intent());
        offset += this.bodyDecoder.sbeBlockLength();
        int valueLength = this.bodyDecoder.valueLength();
        this.value.wrap(buffer, offset += ExecuteCommandRequestDecoder.valueHeaderLength(), valueLength);
        offset += valueLength;
        int authorizationLength = this.bodyDecoder.authorizationLength();
        this.authorization.wrap(buffer, offset += ExecuteCommandRequestDecoder.authorizationHeaderLength(), authorizationLength);
        this.bodyDecoder.limit(offset += authorizationLength);
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public int getLength() {
        return 28 + ExecuteCommandRequestEncoder.valueHeaderLength() + this.value.capacity() + ExecuteCommandRequestEncoder.authorizationHeaderLength() + this.authorization.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).partitionId(this.partitionId).key(this.key).operationReference(this.operationReference).valueType(this.valueType).intent(this.intent.value()).putValue(this.value, 0, this.value.capacity()).putAuthorization(this.authorization.toDirectBuffer(), 0, this.authorization.getLength());
    }
}

