/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.impl.RetriableStreamingFutureImpl;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.ActivateJobsResponseImpl;
import io.camunda.zeebe.client.protocol.rest.JobActivationRequest;
import io.camunda.zeebe.client.protocol.rest.JobActivationResponse;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class ActivateJobsCommandImpl
implements ActivateJobsCommandStep1,
ActivateJobsCommandStep1.ActivateJobsCommandStep2,
ActivateJobsCommandStep1.ActivateJobsCommandStep3 {
    private static final Duration DEADLINE_OFFSET = Duration.ofSeconds(10L);
    private final GatewayGrpc.GatewayStub asyncStub;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final GatewayOuterClass.ActivateJobsRequest.Builder grpcRequestObjectBuilder;
    private final JobActivationRequest httpRequestObject;
    private Duration requestTimeout;
    private boolean useRest;
    private final Set<String> defaultTenantIds;
    private final Set<String> customTenantIds;

    public ActivateJobsCommandImpl(GatewayGrpc.GatewayStub asyncStub, HttpClient httpClient, ZeebeClientConfiguration config, JsonMapper jsonMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        this.asyncStub = asyncStub;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.jsonMapper = jsonMapper;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.ActivateJobsRequest.newBuilder();
        this.httpRequestObject = new JobActivationRequest();
        this.requestTimeout(config.getDefaultRequestTimeout());
        this.timeout(config.getDefaultJobTimeout());
        this.workerName(config.getDefaultJobWorkerName());
        this.useRest = config.preferRestOverGrpc();
        this.defaultTenantIds = new HashSet<String>(config.getDefaultJobWorkerTenantIds());
        this.customTenantIds = new HashSet<String>();
    }

    @Override
    public ActivateJobsCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public ActivateJobsCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep2 jobType(String jobType) {
        this.grpcRequestObjectBuilder.setType(jobType);
        this.httpRequestObject.setType(jobType);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 maxJobsToActivate(int maxJobsToActivate) {
        this.grpcRequestObjectBuilder.setMaxJobsToActivate(maxJobsToActivate);
        this.httpRequestObject.setMaxJobsToActivate(maxJobsToActivate);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 timeout(Duration timeout) {
        this.grpcRequestObjectBuilder.setTimeout(timeout.toMillis());
        this.httpRequestObject.setTimeout(timeout.toMillis());
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 workerName(String workerName) {
        if (workerName != null) {
            this.grpcRequestObjectBuilder.setWorker(workerName);
            this.httpRequestObject.setWorker(workerName);
        }
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 fetchVariables(List<String> fetchVariables) {
        this.grpcRequestObjectBuilder.addAllFetchVariable(fetchVariables);
        this.httpRequestObject.fetchVariable(fetchVariables);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 fetchVariables(String ... fetchVariables) {
        return this.fetchVariables(Arrays.asList(fetchVariables));
    }

    @Override
    public FinalCommandStep<ActivateJobsResponse> requestTimeout(Duration requestTimeout) {
        this.grpcRequestObjectBuilder.setRequestTimeout(requestTimeout.toMillis());
        this.httpRequestObject.setRequestTimeout(requestTimeout.toMillis());
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<ActivateJobsResponse> send() {
        this.grpcRequestObjectBuilder.clearTenantIds();
        this.httpRequestObject.setTenantIds(new ArrayList<String>());
        if (this.customTenantIds.isEmpty()) {
            this.grpcRequestObjectBuilder.addAllTenantIds(this.defaultTenantIds);
            this.httpRequestObject.setTenantIds(new ArrayList<String>(this.defaultTenantIds));
        } else {
            this.grpcRequestObjectBuilder.addAllTenantIds(this.customTenantIds);
            this.httpRequestObject.setTenantIds(new ArrayList<String>(this.customTenantIds));
        }
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<ActivateJobsResponse> sendRestRequest() {
        HttpZeebeFuture<ActivateJobsResponse> result = new HttpZeebeFuture<ActivateJobsResponse>();
        ActivateJobsResponseImpl response = new ActivateJobsResponseImpl(this.jsonMapper);
        this.httpClient.post("/jobs/activation", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), JobActivationResponse.class, response::addResponse, result);
        return result;
    }

    private ZeebeFuture<ActivateJobsResponse> sendGrpcRequest() {
        GatewayOuterClass.ActivateJobsRequest request = this.grpcRequestObjectBuilder.build();
        ActivateJobsResponseImpl response = new ActivateJobsResponseImpl(this.jsonMapper);
        RetriableStreamingFutureImpl<ActivateJobsResponseImpl, GatewayOuterClass.ActivateJobsResponse> future = new RetriableStreamingFutureImpl<ActivateJobsResponseImpl, GatewayOuterClass.ActivateJobsResponse>(response, response::addResponse, this.retryPredicate, streamObserver -> this.sendGrpc(request, (StreamObserver<GatewayOuterClass.ActivateJobsResponse>)streamObserver));
        this.sendGrpc(request, (StreamObserver<GatewayOuterClass.ActivateJobsResponse>)future);
        return future;
    }

    private void sendGrpc(GatewayOuterClass.ActivateJobsRequest request, StreamObserver<GatewayOuterClass.ActivateJobsResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.plus(DEADLINE_OFFSET).toMillis(), TimeUnit.MILLISECONDS)).activateJobs(request, future);
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 tenantId(String tenantId) {
        this.customTenantIds.add(tenantId);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 tenantIds(List<String> tenantIds) {
        this.customTenantIds.clear();
        this.customTenantIds.addAll(tenantIds);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 tenantIds(String ... tenantIds) {
        return this.tenantIds((List)Arrays.asList(tenantIds));
    }
}

