/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Base properties for EvaluateDecisionResponse
 */
@JsonPropertyOrder({
  EvaluateDecisionResponseBase.JSON_PROPERTY_DECISION_DEFINITION_ID,
  EvaluateDecisionResponseBase.JSON_PROPERTY_DECISION_DEFINITION_NAME,
  EvaluateDecisionResponseBase.JSON_PROPERTY_DECISION_DEFINITION_VERSION,
  EvaluateDecisionResponseBase.JSON_PROPERTY_DECISION_REQUIREMENTS_ID,
  EvaluateDecisionResponseBase.JSON_PROPERTY_OUTPUT,
  EvaluateDecisionResponseBase.JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID,
  EvaluateDecisionResponseBase.JSON_PROPERTY_FAILURE_MESSAGE,
  EvaluateDecisionResponseBase.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-07T09:07:49.077422923Z[GMT]", comments = "Generator version: 7.8.0")
public class EvaluateDecisionResponseBase {
  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  private String decisionDefinitionId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  private String decisionDefinitionName;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_VERSION = "decisionDefinitionVersion";
  private Integer decisionDefinitionVersion;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_ID = "decisionRequirementsId";
  private String decisionRequirementsId;

  public static final String JSON_PROPERTY_OUTPUT = "output";
  private String output;

  public static final String JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID = "failedDecisionDefinitionId";
  private String failedDecisionDefinitionId;

  public static final String JSON_PROPERTY_FAILURE_MESSAGE = "failureMessage";
  private String failureMessage;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public EvaluateDecisionResponseBase() {
  }

  public EvaluateDecisionResponseBase decisionDefinitionId(String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which was evaluated.
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public EvaluateDecisionResponseBase decisionDefinitionName(String decisionDefinitionName) {
    
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the decision which was evaluated.
   * @return decisionDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public EvaluateDecisionResponseBase decisionDefinitionVersion(Integer decisionDefinitionVersion) {
    
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision which was evaluated.
   * @return decisionDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public EvaluateDecisionResponseBase decisionRequirementsId(String decisionRequirementsId) {
    
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The ID of the decision requirements graph that the decision which was evaluated is part of.
   * @return decisionRequirementsId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public EvaluateDecisionResponseBase output(String output) {
    
    this.output = output;
    return this;
  }

  /**
   * JSON document that will instantiate the result of the decision which was evaluated. 
   * @return output
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OUTPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOutput() {
    return output;
  }


  @JsonProperty(JSON_PROPERTY_OUTPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutput(String output) {
    this.output = output;
  }

  public EvaluateDecisionResponseBase failedDecisionDefinitionId(String failedDecisionDefinitionId) {
    
    this.failedDecisionDefinitionId = failedDecisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which failed during evaluation.
   * @return failedDecisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFailedDecisionDefinitionId() {
    return failedDecisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_FAILED_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailedDecisionDefinitionId(String failedDecisionDefinitionId) {
    this.failedDecisionDefinitionId = failedDecisionDefinitionId;
  }

  public EvaluateDecisionResponseBase failureMessage(String failureMessage) {
    
    this.failureMessage = failureMessage;
    return this;
  }

  /**
   * Message describing why the decision which was evaluated failed.
   * @return failureMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FAILURE_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFailureMessage() {
    return failureMessage;
  }


  @JsonProperty(JSON_PROPERTY_FAILURE_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailureMessage(String failureMessage) {
    this.failureMessage = failureMessage;
  }

  public EvaluateDecisionResponseBase tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the evaluated decision.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluateDecisionResponseBase evaluateDecisionResponseBase = (EvaluateDecisionResponseBase) o;
    return Objects.equals(this.decisionDefinitionId, evaluateDecisionResponseBase.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, evaluateDecisionResponseBase.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, evaluateDecisionResponseBase.decisionDefinitionVersion) &&
        Objects.equals(this.decisionRequirementsId, evaluateDecisionResponseBase.decisionRequirementsId) &&
        Objects.equals(this.output, evaluateDecisionResponseBase.output) &&
        Objects.equals(this.failedDecisionDefinitionId, evaluateDecisionResponseBase.failedDecisionDefinitionId) &&
        Objects.equals(this.failureMessage, evaluateDecisionResponseBase.failureMessage) &&
        Objects.equals(this.tenantId, evaluateDecisionResponseBase.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionRequirementsId, output, failedDecisionDefinitionId, failureMessage, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluateDecisionResponseBase {\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    output: ").append(toIndentedString(output)).append("\n");
    sb.append("    failedDecisionDefinitionId: ").append(toIndentedString(failedDecisionDefinitionId)).append("\n");
    sb.append("    failureMessage: ").append(toIndentedString(failureMessage)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionName` to the URL query string
    if (getDecisionDefinitionName() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionVersion` to the URL query string
    if (getDecisionDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsId` to the URL query string
    if (getDecisionRequirementsId() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `output` to the URL query string
    if (getOutput() != null) {
      try {
        joiner.add(String.format("%soutput%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOutput()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failedDecisionDefinitionId` to the URL query string
    if (getFailedDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sfailedDecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailedDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failureMessage` to the URL query string
    if (getFailureMessage() != null) {
      try {
        joiner.add(String.format("%sfailureMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailureMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

