/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceFilter;
import io.camunda.zeebe.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.zeebe.client.protocol.rest.SearchQuerySortRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"filter", "sort", "page"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessInstanceSearchQuery {
    public static final String JSON_PROPERTY_FILTER = "filter";
    private ProcessInstanceFilter filter;
    public static final String JSON_PROPERTY_SORT = "sort";
    private List<SearchQuerySortRequest> sort = new ArrayList<SearchQuerySortRequest>();
    public static final String JSON_PROPERTY_PAGE = "page";
    private SearchQueryPageRequest page;

    public ProcessInstanceSearchQuery filter(ProcessInstanceFilter filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessInstanceFilter getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(ProcessInstanceFilter filter) {
        this.filter = filter;
    }

    public ProcessInstanceSearchQuery sort(List<SearchQuerySortRequest> sort) {
        this.sort = sort;
        return this;
    }

    public ProcessInstanceSearchQuery addSortItem(SearchQuerySortRequest sortItem) {
        if (this.sort == null) {
            this.sort = new ArrayList<SearchQuerySortRequest>();
        }
        this.sort.add(sortItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SearchQuerySortRequest> getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(List<SearchQuerySortRequest> sort) {
        this.sort = sort;
    }

    public ProcessInstanceSearchQuery page(SearchQueryPageRequest page) {
        this.page = page;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchQueryPageRequest getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(SearchQueryPageRequest page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceSearchQuery processInstanceSearchQuery = (ProcessInstanceSearchQuery)o;
        return Objects.equals(this.filter, processInstanceSearchQuery.filter) && Objects.equals(this.sort, processInstanceSearchQuery.sort) && Objects.equals(this.page, processInstanceSearchQuery.page);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort, this.page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceSearchQuery {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSort() != null) {
            for (int i = 0; i < this.getSort().size(); ++i) {
                if (this.getSort().get(i) == null) continue;
                joiner.add(this.getSort().get(i).toUrlQueryString(String.format("%ssort%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getPage() != null) {
            joiner.add(this.getPage().toUrlQueryString(prefix + JSON_PROPERTY_PAGE + suffix));
        }
        return joiner.toString();
    }
}

