/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.DecisionRequirementsFilter;
import io.camunda.zeebe.client.api.search.query.DecisionRequirementsQuery;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.response.DecisionRequirements;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.sort.DecisionRequirementsSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchRequestPageImpl;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.impl.search.sort.DecisionRequirementsSortImpl;
import io.camunda.zeebe.client.protocol.rest.DecisionRequirementsFilterRequest;
import io.camunda.zeebe.client.protocol.rest.DecisionRequirementsSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.DecisionRequirementsSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.SearchQuerySortRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionRequirementsQueryImpl
extends TypedSearchRequestPropertyProvider<DecisionRequirementsSearchQueryRequest>
implements DecisionRequirementsQuery {
    private final DecisionRequirementsSearchQueryRequest request = new DecisionRequirementsSearchQueryRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionRequirementsQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<DecisionRequirements> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public HttpZeebeFuture<SearchQueryResponse<DecisionRequirements>> send() {
        HttpZeebeFuture<SearchQueryResponse<DecisionRequirements>> result = new HttpZeebeFuture<SearchQueryResponse<DecisionRequirements>>();
        this.httpClient.post("/decision-requirements/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionRequirementsSearchQueryResponse.class, SearchResponseMapper::toDecisionRequirementsSearchResponse, result);
        return result;
    }

    @Override
    public DecisionRequirementsQuery filter(DecisionRequirementsFilter value) {
        DecisionRequirementsFilterRequest filter = (DecisionRequirementsFilterRequest)DecisionRequirementsQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public DecisionRequirementsQuery filter(Consumer<DecisionRequirementsFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionRequirementsFilter(fn));
    }

    @Override
    public DecisionRequirementsQuery sort(DecisionRequirementsSort value) {
        DecisionRequirementsSortImpl sorting = (DecisionRequirementsSortImpl)value;
        this.request.setSort((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty());
        return this;
    }

    @Override
    public DecisionRequirementsQuery sort(Consumer<DecisionRequirementsSort> fn) {
        return this.sort(SearchRequestBuilders.decisionRequirementsSort(fn));
    }

    @Override
    public DecisionRequirementsQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public DecisionRequirementsQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionRequirementsSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

