/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.response.EvaluatedDecisionInput;
import io.camunda.client.api.response.MatchedDecisionRule;
import io.camunda.client.api.search.response.DecisionDefinitionType;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.DecisionInstanceState;
import io.camunda.client.impl.response.EvaluatedDecisionInputImpl;
import io.camunda.client.impl.response.MatchedDecisionRuleImpl;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.DecisionDefinitionTypeEnum;
import io.camunda.client.protocol.rest.DecisionInstanceGetQueryResult;
import io.camunda.client.protocol.rest.DecisionInstanceResult;
import io.camunda.client.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.client.protocol.rest.EvaluatedDecisionInputItem;
import io.camunda.client.protocol.rest.MatchedDecisionRuleItem;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DecisionInstanceImpl
implements DecisionInstance {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final long decisionInstanceKey;
    private final String decisionInstanceId;
    private final DecisionInstanceState state;
    private final OffsetDateTime evaluationDate;
    private final String evaluationFailure;
    private final Long processDefinitionKey;
    private final Long processInstanceKey;
    private final Long elementInstanceKey;
    private final long decisionKey;
    private final String decisionDefinitionId;
    private final String decisionDefinitionName;
    private final int decisionDefinitionVersion;
    private final DecisionDefinitionType decisionDefinitionType;
    private final String tenantId;
    private final List<EvaluatedDecisionInput> evaluatedInputs;
    private final List<MatchedDecisionRule> matchedRules;
    private final String result;

    public DecisionInstanceImpl(DecisionInstanceResult item, JsonMapper jsonMapper) {
        this(jsonMapper, Long.parseLong(item.getDecisionEvaluationKey()), item.getDecisionEvaluationInstanceKey(), DecisionInstanceImpl.toDecisionInstanceState(item.getState()), ParseUtil.parseOffsetDateTimeOrNull(item.getEvaluationDate()), item.getEvaluationFailure(), Long.parseLong(item.getProcessDefinitionKey()), Long.parseLong(item.getProcessInstanceKey()), Long.parseLong(item.getElementInstanceKey()), Long.parseLong(item.getDecisionDefinitionKey()), item.getDecisionDefinitionId(), item.getDecisionDefinitionName(), item.getDecisionDefinitionVersion(), DecisionInstanceImpl.toDecisionDefinitionType(item.getDecisionDefinitionType()), item.getTenantId(), null, null, item.getResult());
    }

    public DecisionInstanceImpl(DecisionInstanceGetQueryResult item, JsonMapper jsonMapper) {
        this(jsonMapper, Long.parseLong(item.getDecisionEvaluationKey()), item.getDecisionEvaluationInstanceKey(), DecisionInstanceImpl.toDecisionInstanceState(item.getState()), ParseUtil.parseOffsetDateTimeOrNull(item.getEvaluationDate()), item.getEvaluationFailure(), Long.parseLong(item.getProcessDefinitionKey()), Long.parseLong(item.getProcessInstanceKey()), Long.parseLong(item.getElementInstanceKey()), Long.parseLong(item.getDecisionDefinitionKey()), item.getDecisionDefinitionId(), item.getDecisionDefinitionName(), item.getDecisionDefinitionVersion(), DecisionInstanceImpl.toDecisionDefinitionType(item.getDecisionDefinitionType()), item.getTenantId(), item.getEvaluatedInputs().stream().map(input -> new EvaluatedDecisionInputImpl((EvaluatedDecisionInputItem)input, jsonMapper)).collect(Collectors.toList()), item.getMatchedRules().stream().map(rule -> new MatchedDecisionRuleImpl((MatchedDecisionRuleItem)rule, jsonMapper)).collect(Collectors.toList()), item.getResult());
    }

    public DecisionInstanceImpl(JsonMapper jsonMapper, long decisionInstanceKey, String decisionInstanceId, DecisionInstanceState state, OffsetDateTime evaluationDate, String evaluationFailure, Long processDefinitionKey, Long processInstanceKey, Long elementInstanceKey, long decisionKey, String decisionDefinitionId, String decisionDefinitionName, int decisionDefinitionVersion, DecisionDefinitionType decisionDefinitionType, String tenantId, List<EvaluatedDecisionInput> evaluatedInputs, List<MatchedDecisionRule> matchedRules, String result) {
        this.jsonMapper = jsonMapper;
        this.decisionInstanceKey = decisionInstanceKey;
        this.decisionInstanceId = decisionInstanceId;
        this.state = state;
        this.evaluationDate = evaluationDate;
        this.evaluationFailure = evaluationFailure;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.elementInstanceKey = elementInstanceKey;
        this.decisionKey = decisionKey;
        this.decisionDefinitionId = decisionDefinitionId;
        this.decisionDefinitionName = decisionDefinitionName;
        this.decisionDefinitionVersion = decisionDefinitionVersion;
        this.decisionDefinitionType = decisionDefinitionType;
        this.tenantId = tenantId;
        this.evaluatedInputs = evaluatedInputs;
        this.matchedRules = matchedRules;
        this.result = result;
    }

    private static DecisionDefinitionType toDecisionDefinitionType(DecisionDefinitionTypeEnum decisionDefinitionType) {
        if (decisionDefinitionType == null) {
            return null;
        }
        switch (decisionDefinitionType) {
            case DECISION_TABLE: {
                return DecisionDefinitionType.DECISION_TABLE;
            }
            case LITERAL_EXPRESSION: {
                return DecisionDefinitionType.LITERAL_EXPRESSION;
            }
            case UNSPECIFIED: {
                return DecisionDefinitionType.UNSPECIFIED;
            }
            case UNKNOWN: {
                return DecisionDefinitionType.UNKNOWN;
            }
        }
        EnumUtil.logUnknownEnumValue((Object)decisionDefinitionType, "decision definition type", DecisionDefinitionType.values());
        return DecisionDefinitionType.UNKNOWN_ENUM_VALUE;
    }

    private static DecisionInstanceState toDecisionInstanceState(DecisionInstanceStateEnum decisionInstanceState) {
        if (decisionInstanceState == null) {
            return null;
        }
        switch (decisionInstanceState) {
            case EVALUATED: {
                return DecisionInstanceState.EVALUATED;
            }
            case FAILED: {
                return DecisionInstanceState.FAILED;
            }
            case UNSPECIFIED: {
                return DecisionInstanceState.UNSPECIFIED;
            }
            case UNKNOWN: {
                return DecisionInstanceState.UNKNOWN;
            }
        }
        EnumUtil.logUnknownEnumValue((Object)decisionInstanceState, "decision instance state", DecisionInstanceState.values());
        return DecisionInstanceState.UNKNOWN_ENUM_VALUE;
    }

    @Override
    public long getDecisionInstanceKey() {
        return this.decisionInstanceKey;
    }

    @Override
    public String getDecisionInstanceId() {
        return this.decisionInstanceId;
    }

    @Override
    public DecisionInstanceState getState() {
        return this.state;
    }

    @Override
    public OffsetDateTime getEvaluationDate() {
        return this.evaluationDate;
    }

    @Override
    public String getEvaluationFailure() {
        return this.evaluationFailure;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public long getDecisionDefinitionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    @Override
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    @Override
    public int getDecisionDefinitionVersion() {
        return this.decisionDefinitionVersion;
    }

    @Override
    public DecisionDefinitionType getDecisionDefinitionType() {
        return this.decisionDefinitionType;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public List<EvaluatedDecisionInput> getEvaluatedInputs() {
        return this.evaluatedInputs;
    }

    @Override
    public List<MatchedDecisionRule> getMatchedRules() {
        return this.matchedRules;
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public String toJson() {
        return this.jsonMapper.toJson(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.decisionInstanceKey, this.decisionInstanceId, this.state, this.evaluationDate, this.evaluationFailure, this.processDefinitionKey, this.processInstanceKey, this.elementInstanceKey, this.decisionKey, this.decisionDefinitionId, this.decisionDefinitionName, this.decisionDefinitionVersion, this.decisionDefinitionType, this.tenantId, this.evaluatedInputs, this.matchedRules});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionInstanceImpl that = (DecisionInstanceImpl)o;
        return this.decisionInstanceKey == that.decisionInstanceKey && this.decisionKey == that.decisionKey && this.decisionDefinitionVersion == that.decisionDefinitionVersion && this.state == that.state && Objects.equals(this.decisionInstanceId, that.decisionInstanceId) && Objects.equals(this.evaluationDate, that.evaluationDate) && Objects.equals(this.evaluationFailure, that.evaluationFailure) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.elementInstanceKey, that.elementInstanceKey) && Objects.equals(this.decisionDefinitionId, that.decisionDefinitionId) && Objects.equals(this.decisionDefinitionName, that.decisionDefinitionName) && this.decisionDefinitionType == that.decisionDefinitionType && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.evaluatedInputs, that.evaluatedInputs) && Objects.equals(this.matchedRules, that.matchedRules);
    }
}

