/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.TenantFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.TenantsSearchRequest;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.Tenant;
import io.camunda.client.api.search.sort.TenantSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.TenantSearchQueryRequest;
import io.camunda.client.protocol.rest.TenantSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class TenantsSearchRequestImpl
extends TypedSearchRequestPropertyProvider<TenantSearchQueryRequest>
implements TenantsSearchRequest {
    private final TenantSearchQueryRequest request;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;

    public TenantsSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new TenantSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Tenant> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Tenant>> send() {
        HttpCamundaFuture<SearchResponse<Tenant>> result = new HttpCamundaFuture<SearchResponse<Tenant>>();
        this.httpClient.post("/tenants/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), TenantSearchQueryResult.class, SearchResponseMapper::toTenantsResponse, result);
        return result;
    }

    @Override
    public TenantsSearchRequest filter(TenantFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.TenantFilter)TenantsSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public TenantsSearchRequest filter(Consumer<TenantFilter> fn) {
        return this.filter(SearchRequestBuilders.tenantFilter(fn));
    }

    @Override
    public TenantsSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)TenantsSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public TenantsSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public TenantsSearchRequest sort(TenantSort value) {
        this.request.setSort(SearchRequestSortMapper.toTenantSearchQuerySortRequest((List)TenantsSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public TenantsSearchRequest sort(Consumer<TenantSort> fn) {
        return this.sort(SearchRequestBuilders.tenantSort(fn));
    }

    @Override
    protected TenantSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

