/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.IncidentSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.IncidentSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.IncidentFilter;
import io.camunda.client.protocol.rest.IncidentSearchQuery;
import io.camunda.client.protocol.rest.IncidentSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class IncidentSearchRequestImpl
extends TypedSearchRequestPropertyProvider<IncidentSearchQuery>
implements IncidentSearchRequest {
    private final IncidentSearchQuery request = new IncidentSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public IncidentSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<Incident> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Incident>> send() {
        HttpCamundaFuture<SearchResponse<Incident>> result = new HttpCamundaFuture<SearchResponse<Incident>>();
        this.httpClient.post("/incidents/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), IncidentSearchQueryResult.class, SearchResponseMapper::toIncidentSearchResponse, result);
        return result;
    }

    @Override
    public IncidentSearchRequest filter(io.camunda.client.api.search.filter.IncidentFilter value) {
        this.request.setFilter((IncidentFilter)IncidentSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public IncidentSearchRequest filter(Consumer<io.camunda.client.api.search.filter.IncidentFilter> fn) {
        return this.filter(SearchRequestBuilders.incidentFilter(fn));
    }

    @Override
    public IncidentSearchRequest sort(IncidentSort value) {
        this.request.setSort(SearchRequestSortMapper.toIncidentSearchQuerySortRequest((List)IncidentSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public IncidentSearchRequest sort(Consumer<IncidentSort> fn) {
        return this.sort(SearchRequestBuilders.incidentSort(fn));
    }

    @Override
    public IncidentSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)IncidentSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public IncidentSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected IncidentSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

