/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.response;

import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.client.protocol.rest.CreateProcessInstanceResult;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class CreateProcessInstanceResponseImpl
implements ProcessInstanceEvent {
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private final int version;
    private final long processInstanceKey;
    private final String tenantId;
    private final Set<String> tags;

    public CreateProcessInstanceResponseImpl(GatewayOuterClass.CreateProcessInstanceResponse response) {
        this.processDefinitionKey = response.getProcessDefinitionKey();
        this.bpmnProcessId = response.getBpmnProcessId();
        this.version = response.getVersion();
        this.processInstanceKey = response.getProcessInstanceKey();
        this.tenantId = response.getTenantId();
        this.tags = Collections.unmodifiableSet(new HashSet(response.getTagsList()));
    }

    public CreateProcessInstanceResponseImpl(CreateProcessInstanceResult response) {
        this.processDefinitionKey = Long.parseLong(response.getProcessDefinitionKey());
        this.bpmnProcessId = response.getProcessDefinitionId();
        this.version = response.getProcessDefinitionVersion();
        this.processInstanceKey = Long.parseLong(response.getProcessInstanceKey());
        this.tenantId = response.getTenantId();
        this.tags = response.getTags() == null ? Collections.emptySet() : Collections.unmodifiableSet(response.getTags());
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "CreateProcessInstanceResponseImpl{processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", processInstanceKey=" + this.processInstanceKey + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

