/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignClientFromGroupCommandStep1;
import io.camunda.client.api.response.UnassignClientFromGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UnassignClientFromGroupResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UnassignClientFromGroupCommandImpl
implements UnassignClientFromGroupCommandStep1,
UnassignClientFromGroupCommandStep1.UnassignClientFromGroupCommandStep2,
UnassignClientFromGroupCommandStep1.UnassignClientFromGroupCommandStep3 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String clientId;
    private String groupId;

    public UnassignClientFromGroupCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UnassignClientFromGroupCommandStep1.UnassignClientFromGroupCommandStep2 clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public UnassignClientFromGroupCommandStep1.UnassignClientFromGroupCommandStep3 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignClientFromGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignClientFromGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("clientId", this.clientId);
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<UnassignClientFromGroupResponse> result = new HttpCamundaFuture<UnassignClientFromGroupResponse>();
        this.httpClient.delete("/groups/" + this.groupId + "/clients/" + this.clientId, null, this.httpRequestConfig.build(), UnassignClientFromGroupResponseImpl::new, result);
        return result;
    }
}

