/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateRoleCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CreateRoleResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateRoleResponseImpl;
import io.camunda.client.protocol.rest.RoleCreateRequest;
import io.camunda.client.protocol.rest.RoleCreateResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CreateRoleCommandImpl
implements CreateRoleCommandStep1,
CreateRoleCommandStep1.CreateRoleCommandStep2 {
    private final RoleCreateRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateRoleCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new RoleCreateRequest();
    }

    @Override
    public CreateRoleCommandStep1.CreateRoleCommandStep2 roleId(String roleId) {
        this.request.setRoleId(roleId);
        return this;
    }

    @Override
    public CreateRoleCommandStep1.CreateRoleCommandStep2 name(String name) {
        this.request.name(name);
        return this;
    }

    @Override
    public CreateRoleCommandStep1.CreateRoleCommandStep2 description(String description) {
        this.request.description(description);
        return this;
    }

    @Override
    public FinalCommandStep<CreateRoleResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CreateRoleResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.request.getRoleId());
        ArgumentUtil.ensureNotNullNorEmpty("name", this.request.getName());
        HttpCamundaFuture<CreateRoleResponse> result = new HttpCamundaFuture<CreateRoleResponse>();
        CreateRoleResponseImpl response = new CreateRoleResponseImpl();
        this.httpClient.post("/roles", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), RoleCreateResult.class, response::setResponse, result);
        return result;
    }
}

