/*
 * Decompiled with CFR 0.152.
 */
package io.bluebank.braid.client;

import com.fasterxml.jackson.databind.JavaType;
import io.bluebank.braid.client.BraidClient;
import io.bluebank.braid.client.BraidClientConfig;
import io.bluebank.braid.client.BraidClientKt$sam$Handler$ba22231a;
import io.bluebank.braid.client.BraidProxyClientKt;
import io.bluebank.braid.core.async.AsyncKt;
import io.bluebank.braid.core.json.BraidJacksonInit;
import io.bluebank.braid.core.jsonrpc.JsonRPCRequest;
import io.bluebank.braid.core.jsonrpc.RequestKt;
import io.bluebank.braid.core.reflection.ReflectionKt;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.subjects.PublishSubject;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0002<=B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001b\u001a\u00020\u001cJ%\u0010\u001d\u001a\u0002H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0007\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\nH\u0016J\u0018\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0002J0\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.2\u0010\u0010/\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001f\u0018\u000100H\u0096\u0002\u00a2\u0006\u0002\u00101JA\u00102\u001a\u00060\u0014R\u00020\u00002\u0006\u00103\u001a\u00020\u00182\u0006\u0010-\u001a\u0002042\u0006\u00105\u001a\u0002062\u0016\u00107\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001f00\"\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\tH\u0002R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006>"}, d2={"Lio/bluebank/braid/client/BraidClient;", "Ljava/io/Closeable;", "Ljava/lang/reflect/InvocationHandler;", "config", "Lio/bluebank/braid/client/BraidClientConfig;", "vertx", "Lio/vertx/core/Vertx;", "exceptionHandler", "Lkotlin/Function1;", "", "", "closeHandler", "Lkotlin/Function0;", "(Lio/bluebank/braid/client/BraidClientConfig;Lio/vertx/core/Vertx;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "client", "Lio/vertx/core/http/HttpClient;", "kotlin.jvm.PlatformType", "invocations", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/bluebank/braid/client/BraidClient$ProxyInvocation;", "nextId", "Ljava/util/concurrent/atomic/AtomicLong;", "sock", "Lio/vertx/core/http/WebSocket;", "getVertx", "()Lio/vertx/core/Vertx;", "activeRequestsCount", "", "bind", "ServiceType", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "close", "handleInvocationWithResponse", "responseId", "jo", "Lio/vertx/core/json/JsonObject;", "handler", "buffer", "Lio/vertx/core/buffer/Buffer;", "invoke", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "jsonRPC", "socket", "", "returnType", "Ljava/lang/reflect/Type;", "params", "(Lio/vertx/core/http/WebSocket;Ljava/lang/String;Ljava/lang/reflect/Type;[Ljava/lang/Object;)Lio/bluebank/braid/client/BraidClient$ProxyInvocation;", "onRequestError", "id", "err", "Companion", "ProxyInvocation", "braid-client"})
public class BraidClient
implements Closeable,
InvocationHandler {
    private final AtomicLong nextId;
    private final ConcurrentHashMap<Long, ProxyInvocation> invocations;
    private WebSocket sock;
    private final HttpClient client;
    private final BraidClientConfig config;
    @NotNull
    private final Vertx vertx;
    private static final Logger log;
    public static final Companion Companion;

    public final int activeRequestsCount() {
        return this.invocations.size();
    }

    @NotNull
    public final <ServiceType> ServiceType bind(@NotNull Class<ServiceType> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type ServiceType");
        }
        return (ServiceType)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.client.close();
        }
        finally {
            this.vertx.close();
        }
    }

    @Override
    @NotNull
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        WebSocket socket = this.sock;
        if (socket != null) {
            ProxyInvocation proxyInvocation;
            String string = method.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
            Type type = method.getGenericReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"method.genericReturnType");
            Object[] objectArray = args;
            if (args == null) {
                objectArray = new Object[]{};
            }
            ProxyInvocation it = proxyInvocation = this.jsonRPC(socket, string, type, Arrays.copyOf(objectArray, objectArray.length));
            return RequestKt.asMDC((long)it.getInvocationId$braid_client(), (Function0)((Function0)new Function0<Object>(it){
                final /* synthetic */ ProxyInvocation $it;

                @NotNull
                public final Object invoke() {
                    return this.$it.awaitResult();
                }
                {
                    this.$it = proxyInvocation;
                    super(0);
                }
            }));
        }
        throw (Throwable)new IllegalStateException("no socket for proxy");
    }

    private final void handler(Buffer buffer) {
        JsonObject jo = new JsonObject(buffer);
        if (!jo.containsKey("id")) {
            BraidClient.Companion.getLog().warn("received message without 'id' field from " + this.config.getServiceURI());
            return;
        }
        Long responseId = jo.getLong("id");
        try {
            if (responseId == null) {
                BraidClient.Companion.getLog().error("received response without id {}", (Object)buffer.toString());
            } else if (!this.invocations.containsKey(responseId)) {
                BraidClient.Companion.getLog().error("no subscriber found for response id {}", (Object)responseId);
            } else {
                this.handleInvocationWithResponse(responseId, jo);
            }
        }
        catch (Throwable err) {
            BraidClient.Companion.getLog().error("failed to handle response message", err);
        }
    }

    private final void handleInvocationWithResponse(long responseId, JsonObject jo) {
        RequestKt.asMDC((long)responseId, (Function0)((Function0)new Function0<Object>(this, responseId, jo){
            final /* synthetic */ BraidClient this$0;
            final /* synthetic */ long $responseId;
            final /* synthetic */ JsonObject $jo;

            @Nullable
            public final Object invoke() {
                Unit unit;
                ProxyInvocation proxy = (ProxyInvocation)BraidClient.access$getInvocations$p(this.this$0).get(this.$responseId);
                ProxyInvocation proxyInvocation = proxy;
                if (proxyInvocation == null) {
                    io.bluebank.braid.client.BraidClient$Companion.access$getLog$p(BraidClient.Companion).error("failed to find invocation proxy");
                    unit = Unit.INSTANCE;
                } else {
                    Object object;
                    try {
                        proxy.handle(this.$jo);
                        object = Unit.INSTANCE;
                    }
                    catch (Throwable err) {
                        io.bluebank.braid.client.BraidClient$Companion.access$getLog$p(BraidClient.Companion).error("failed to handle message. sending to error handler {}", (Object)this.$jo.encode());
                        try {
                            proxy.onError(err);
                        }
                        catch (Throwable err2) {
                            io.bluebank.braid.client.BraidClient$Companion.access$getLog$p(BraidClient.Companion).error("" + this.$responseId + " - failed to send handler exception to subject", err2);
                        }
                        object = BraidClient.access$getInvocations$p(this.this$0).remove(this.$responseId);
                    }
                    unit = object;
                }
                return unit;
            }
            {
                this.this$0 = braidClient;
                this.$responseId = l;
                this.$jo = jsonObject;
                super(0);
            }
        }));
    }

    private final ProxyInvocation jsonRPC(WebSocket socket, String method, Type returnType, Object ... params) {
        long id = this.nextId.getAndIncrement();
        ProxyInvocation proxyInvocation = new ProxyInvocation(id, returnType);
        Map map = this.invocations;
        Long l = id;
        ProxyInvocation proxyInvocation2 = proxyInvocation;
        map.put(l, proxyInvocation2);
        try {
            JsonRPCRequest request = new JsonRPCRequest(null, id, method, (Object)ArraysKt.toList((Object[])params), ReflectionKt.isStreaming((Type)returnType), 1, null);
            this.vertx.runOnContext((Handler)new Handler<Void>(this, socket, request, id){
                final /* synthetic */ BraidClient this$0;
                final /* synthetic */ WebSocket $socket;
                final /* synthetic */ JsonRPCRequest $request;
                final /* synthetic */ long $id;

                public final void handle(Void it) {
                    try {
                        this.$socket.writeFrame(WebSocketFrame.textFrame((String)Json.encode((Object)this.$request), (boolean)true));
                    }
                    catch (IllegalStateException e) {
                        BraidClient.access$onRequestError(this.this$0, this.$id, e);
                    }
                }
                {
                    this.this$0 = braidClient;
                    this.$socket = webSocket;
                    this.$request = jsonRPCRequest;
                    this.$id = l;
                }
            });
        }
        catch (Throwable err) {
            this.onRequestError(id, err);
        }
        return proxyInvocation;
    }

    private final void onRequestError(long id, Throwable err) {
        ProxyInvocation proxyInvocation = this.invocations.get(id);
        if (proxyInvocation != null) {
            proxyInvocation.onError(err);
            this.invocations.remove(id);
        } else {
            BraidClient.Companion.getLog().warn("could not find invocation object " + id + " to report exception", err);
        }
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    public BraidClient(@NotNull BraidClientConfig config, @NotNull Vertx vertx, final @NotNull Function1<? super Throwable, Unit> exceptionHandler, final @NotNull Function0<Unit> closeHandler2) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)vertx, (String)"vertx");
        Intrinsics.checkParameterIsNotNull(exceptionHandler, (String)"exceptionHandler");
        Intrinsics.checkParameterIsNotNull(closeHandler2, (String)"closeHandler");
        this.config = config;
        this.vertx = vertx;
        this.nextId = new AtomicLong(1L);
        this.invocations = new ConcurrentHashMap();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultHost(this.config.getServiceURI().getHost()).setDefaultPort(this.config.getServiceURI().getPort()).setSsl(this.config.getTls()).setVerifyHost(this.config.getVerifyHost()).setTrustAll(this.config.getTrustAll()));
        String protocol = this.config.getTls() ? "https" : "http";
        URL url = new URL(protocol, this.config.getServiceURI().getHost(), this.config.getServiceURI().getPort(), "" + this.config.getServiceURI().getPath() + "/websocket");
        final Future result = Future.future();
        this.client.websocket(url.toString(), (Handler)new Handler<WebSocket>(){

            public final void handle(WebSocket socket) {
                try {
                    sock = socket;
                    Function1 function1 = (Function1)new Function1<Buffer, Unit>(this){

                        public final void invoke(@NotNull Buffer p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            ((BraidClient)this.receiver).handler(p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(BraidClient.class);
                        }

                        public final String getName() {
                            return "handler";
                        }

                        public final String getSignature() {
                            return "handler(Lio/vertx/core/buffer/Buffer;)V";
                        }
                    };
                    socket.handler((Handler)new BraidClientKt$sam$Handler$ba22231a(function1));
                    Object object = exceptionHandler;
                    if (object != null) {
                        function1 = object;
                        object = new BraidClientKt$sam$Handler$ba22231a(function1);
                    }
                    socket.exceptionHandler((Handler)object);
                    BraidProxyClientKt.closeHandler(socket, (Function0<Unit>)closeHandler2);
                    result.complete((Object)true);
                }
                catch (Throwable err) {
                    Companion.getLog().error("failed to connect socket to the client stack", err);
                    sock = null;
                    result.fail(err);
                }
            }
        }, (Handler)new Handler<Throwable>(){

            public final void handle(Throwable error) {
                Companion.getLog().error("failed to bind to websocket", error);
                try {
                    sock = null;
                    result.fail(error);
                }
                catch (Throwable err) {
                    Companion.getLog().error("failed to report error on result future", err);
                }
            }
        });
        AsyncKt.getOrThrow((Future)result);
    }

    public /* synthetic */ BraidClient(BraidClientConfig braidClientConfig, Vertx vertx, Function1 function1, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<Throwable, Unit>(Companion){

                public final void invoke(@NotNull Throwable p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    ((Companion)this.receiver).exceptionHandler(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Companion.class);
                }

                public final String getName() {
                    return "exceptionHandler";
                }

                public final String getSignature() {
                    return "exceptionHandler(Ljava/lang/Throwable;)V";
                }
            };
        }
        if ((n & 8) != 0) {
            function0 = (Function0)new Function0<Unit>(Companion){

                public final void invoke() {
                    ((Companion)this.receiver).closeHandler();
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Companion.class);
                }

                public final String getName() {
                    return "closeHandler";
                }

                public final String getSignature() {
                    return "closeHandler()V";
                }
            };
        }
        this(braidClientConfig, vertx, (Function1<? super Throwable, Unit>)function1, (Function0<Unit>)function0);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(BraidClient.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(T::class.java)");
        log = logger;
        BraidJacksonInit.Companion.init();
    }

    public static final /* synthetic */ void access$onRequestError(BraidClient $this, long id, @NotNull Throwable err) {
        $this.onRequestError(id, err);
    }

    @Nullable
    public static final /* synthetic */ WebSocket access$getSock$p(BraidClient $this) {
        return $this.sock;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u0001J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/bluebank/braid/client/BraidClient$ProxyInvocation;", "", "invocationId", "", "returnType", "Ljava/lang/reflect/Type;", "(Lio/bluebank/braid/client/BraidClient;JLjava/lang/reflect/Type;)V", "getInvocationId$braid_client", "()J", "payloadType", "Lcom/fasterxml/jackson/databind/JavaType;", "kotlin.jvm.PlatformType", "resultBuffer", "Lrx/subjects/PublishSubject;", "awaitResult", "handle", "", "jo", "Lio/vertx/core/json/JsonObject;", "onError", "err", "", "braid-client"})
    private final class ProxyInvocation {
        private final JavaType payloadType;
        private final PublishSubject<Object> resultBuffer;
        private final long invocationId;
        private final Type returnType;

        @NotNull
        public final Object awaitResult() {
            Type type = ReflectionKt.actualType((Type)this.returnType);
            Object object = Intrinsics.areEqual((Object)type, Future.class) ? AsyncKt.toFuture((Observable)this.resultBuffer.doOnNext((Action1)awaitResult.1.INSTANCE).doOnError((Action1)awaitResult.2.INSTANCE).doOnCompleted((Action0)awaitResult.3.INSTANCE)) : (Intrinsics.areEqual((Object)type, Observable.class) ? this.resultBuffer : this.resultBuffer.toBlocking().first());
            Intrinsics.checkExpressionValueIsNotNull(object, (String)"when (returnType.actualT\u2026first()\n        }\n      }");
            return object;
        }

        public final void handle(@NotNull JsonObject jo) {
            Intrinsics.checkParameterIsNotNull((Object)jo, (String)"jo");
            if (Companion.getLog().isTraceEnabled()) {
                Companion.getLog().trace("handling received message {}", (Object)jo.encode());
            }
            if (jo.containsKey("result")) {
                Object raw = jo.getValue("result");
                Object result = Json.mapper.convertValue(raw, this.payloadType);
                if (ReflectionKt.isStreaming((Type)this.returnType)) {
                    Companion.getLog().trace("pushing message to streaming subject: {}", result);
                    this.resultBuffer.onNext(result);
                } else {
                    Companion.getLog().trace("pushing message to non-streaming subject and completing the subject: {}", result);
                    BraidClient.this.invocations.remove(this.invocationId);
                    this.resultBuffer.onNext(result);
                    this.resultBuffer.onCompleted();
                }
            } else if (jo.containsKey("error")) {
                Companion.getLog().trace("message is an error response. terminating the subject");
                JsonObject error = jo.getJsonObject("error");
                BraidClient.this.invocations.remove(this.invocationId);
                this.onError(new RuntimeException(error.getString("message")));
            } else if (jo.containsKey("completed")) {
                Companion.getLog().trace("message is a completion response");
                if (!ReflectionKt.isStreaming((Type)this.returnType)) {
                    Companion.getLog().error("Not expecting completed messages for anything other than Observables");
                }
                BraidClient.this.invocations.remove(this.invocationId);
                this.resultBuffer.onCompleted();
            }
        }

        public final void onError(@NotNull Throwable err) {
            Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
            this.resultBuffer.onError(err);
        }

        public final long getInvocationId$braid_client() {
            return this.invocationId;
        }

        public ProxyInvocation(@NotNull long invocationId, Type returnType) {
            Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
            this.invocationId = invocationId;
            this.returnType = returnType;
            this.payloadType = Json.mapper.getTypeFactory().constructType(ReflectionKt.underlyingGenericType((Type)this.returnType));
            this.resultBuffer = PublishSubject.create();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lio/bluebank/braid/client/BraidClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "closeHandler", "", "createClient", "Lio/bluebank/braid/client/BraidClient;", "config", "Lio/bluebank/braid/client/BraidClientConfig;", "vertx", "Lio/vertx/core/Vertx;", "exceptionHandler", "error", "", "braid-client"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        @NotNull
        public final BraidClient createClient(@NotNull BraidClientConfig config, @NotNull Vertx vertx) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Intrinsics.checkParameterIsNotNull((Object)vertx, (String)"vertx");
            return new BraidClient(config, vertx, null, null, 12, null);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ BraidClient createClient$default(Companion companion, BraidClientConfig braidClientConfig, Vertx vertx, int n, Object object) {
            if ((n & 2) != 0) {
                Vertx vertx2 = Vertx.vertx();
                Intrinsics.checkExpressionValueIsNotNull((Object)vertx2, (String)"Vertx.vertx()");
                vertx = vertx2;
            }
            return companion.createClient(braidClientConfig, vertx);
        }

        private final void closeHandler() {
            this.getLog().info("closing...");
        }

        private final void exceptionHandler(Throwable error) {
            this.getLog().error("exception from socket", error);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

