package io.axoniq.axonserver.grpc.event;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * Service to use AxonServer as a provider of an EventScheduler 
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.19.0)",
    comments = "Source: event.proto")
public final class EventSchedulerGrpc {

  private EventSchedulerGrpc() {}

  public static final String SERVICE_NAME = "io.axoniq.axonserver.grpc.event.EventScheduler";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.ScheduleEventRequest,
      io.axoniq.axonserver.grpc.event.ScheduleToken> getScheduleEventMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ScheduleEvent",
      requestType = io.axoniq.axonserver.grpc.event.ScheduleEventRequest.class,
      responseType = io.axoniq.axonserver.grpc.event.ScheduleToken.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.ScheduleEventRequest,
      io.axoniq.axonserver.grpc.event.ScheduleToken> getScheduleEventMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.ScheduleEventRequest, io.axoniq.axonserver.grpc.event.ScheduleToken> getScheduleEventMethod;
    if ((getScheduleEventMethod = EventSchedulerGrpc.getScheduleEventMethod) == null) {
      synchronized (EventSchedulerGrpc.class) {
        if ((getScheduleEventMethod = EventSchedulerGrpc.getScheduleEventMethod) == null) {
          EventSchedulerGrpc.getScheduleEventMethod = getScheduleEventMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.ScheduleEventRequest, io.axoniq.axonserver.grpc.event.ScheduleToken>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventScheduler", "ScheduleEvent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.ScheduleEventRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.ScheduleToken.getDefaultInstance()))
                  .setSchemaDescriptor(new EventSchedulerMethodDescriptorSupplier("ScheduleEvent"))
                  .build();
          }
        }
     }
     return getScheduleEventMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.RescheduleEventRequest,
      io.axoniq.axonserver.grpc.event.ScheduleToken> getRescheduleEventMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RescheduleEvent",
      requestType = io.axoniq.axonserver.grpc.event.RescheduleEventRequest.class,
      responseType = io.axoniq.axonserver.grpc.event.ScheduleToken.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.RescheduleEventRequest,
      io.axoniq.axonserver.grpc.event.ScheduleToken> getRescheduleEventMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.RescheduleEventRequest, io.axoniq.axonserver.grpc.event.ScheduleToken> getRescheduleEventMethod;
    if ((getRescheduleEventMethod = EventSchedulerGrpc.getRescheduleEventMethod) == null) {
      synchronized (EventSchedulerGrpc.class) {
        if ((getRescheduleEventMethod = EventSchedulerGrpc.getRescheduleEventMethod) == null) {
          EventSchedulerGrpc.getRescheduleEventMethod = getRescheduleEventMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.RescheduleEventRequest, io.axoniq.axonserver.grpc.event.ScheduleToken>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventScheduler", "RescheduleEvent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.RescheduleEventRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.ScheduleToken.getDefaultInstance()))
                  .setSchemaDescriptor(new EventSchedulerMethodDescriptorSupplier("RescheduleEvent"))
                  .build();
          }
        }
     }
     return getRescheduleEventMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest,
      io.axoniq.axonserver.grpc.InstructionAck> getCancelScheduledEventMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CancelScheduledEvent",
      requestType = io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest.class,
      responseType = io.axoniq.axonserver.grpc.InstructionAck.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest,
      io.axoniq.axonserver.grpc.InstructionAck> getCancelScheduledEventMethod() {
    io.grpc.MethodDescriptor<io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest, io.axoniq.axonserver.grpc.InstructionAck> getCancelScheduledEventMethod;
    if ((getCancelScheduledEventMethod = EventSchedulerGrpc.getCancelScheduledEventMethod) == null) {
      synchronized (EventSchedulerGrpc.class) {
        if ((getCancelScheduledEventMethod = EventSchedulerGrpc.getCancelScheduledEventMethod) == null) {
          EventSchedulerGrpc.getCancelScheduledEventMethod = getCancelScheduledEventMethod = 
              io.grpc.MethodDescriptor.<io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest, io.axoniq.axonserver.grpc.InstructionAck>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "io.axoniq.axonserver.grpc.event.EventScheduler", "CancelScheduledEvent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.axoniq.axonserver.grpc.InstructionAck.getDefaultInstance()))
                  .setSchemaDescriptor(new EventSchedulerMethodDescriptorSupplier("CancelScheduledEvent"))
                  .build();
          }
        }
     }
     return getCancelScheduledEventMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static EventSchedulerStub newStub(io.grpc.Channel channel) {
    return new EventSchedulerStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static EventSchedulerBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new EventSchedulerBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static EventSchedulerFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new EventSchedulerFutureStub(channel);
  }

  /**
   * <pre>
   * Service to use AxonServer as a provider of an EventScheduler 
   * </pre>
   */
  public static abstract class EventSchedulerImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     *  Schedule the given event for publication at the given time}. The returned ScheduleToken can be used to cancel the planned publication.
     * </pre>
     */
    public void scheduleEvent(io.axoniq.axonserver.grpc.event.ScheduleEventRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.ScheduleToken> responseObserver) {
      asyncUnimplementedUnaryCall(getScheduleEventMethod(), responseObserver);
    }

    /**
     * <pre>
     *  Cancel a scheduled event and schedule another in its place.
     * </pre>
     */
    public void rescheduleEvent(io.axoniq.axonserver.grpc.event.RescheduleEventRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.ScheduleToken> responseObserver) {
      asyncUnimplementedUnaryCall(getRescheduleEventMethod(), responseObserver);
    }

    /**
     * <pre>
     *  Cancel the publication of a scheduled event. If the events has already been published, this method does nothing.
     * </pre>
     */
    public void cancelScheduledEvent(io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.InstructionAck> responseObserver) {
      asyncUnimplementedUnaryCall(getCancelScheduledEventMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getScheduleEventMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.ScheduleEventRequest,
                io.axoniq.axonserver.grpc.event.ScheduleToken>(
                  this, METHODID_SCHEDULE_EVENT)))
          .addMethod(
            getRescheduleEventMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.RescheduleEventRequest,
                io.axoniq.axonserver.grpc.event.ScheduleToken>(
                  this, METHODID_RESCHEDULE_EVENT)))
          .addMethod(
            getCancelScheduledEventMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest,
                io.axoniq.axonserver.grpc.InstructionAck>(
                  this, METHODID_CANCEL_SCHEDULED_EVENT)))
          .build();
    }
  }

  /**
   * <pre>
   * Service to use AxonServer as a provider of an EventScheduler 
   * </pre>
   */
  public static final class EventSchedulerStub extends io.grpc.stub.AbstractStub<EventSchedulerStub> {
    private EventSchedulerStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventSchedulerStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventSchedulerStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventSchedulerStub(channel, callOptions);
    }

    /**
     * <pre>
     *  Schedule the given event for publication at the given time}. The returned ScheduleToken can be used to cancel the planned publication.
     * </pre>
     */
    public void scheduleEvent(io.axoniq.axonserver.grpc.event.ScheduleEventRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.ScheduleToken> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getScheduleEventMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *  Cancel a scheduled event and schedule another in its place.
     * </pre>
     */
    public void rescheduleEvent(io.axoniq.axonserver.grpc.event.RescheduleEventRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.ScheduleToken> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRescheduleEventMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *  Cancel the publication of a scheduled event. If the events has already been published, this method does nothing.
     * </pre>
     */
    public void cancelScheduledEvent(io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest request,
        io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.InstructionAck> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCancelScheduledEventMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Service to use AxonServer as a provider of an EventScheduler 
   * </pre>
   */
  public static final class EventSchedulerBlockingStub extends io.grpc.stub.AbstractStub<EventSchedulerBlockingStub> {
    private EventSchedulerBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventSchedulerBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventSchedulerBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventSchedulerBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     *  Schedule the given event for publication at the given time}. The returned ScheduleToken can be used to cancel the planned publication.
     * </pre>
     */
    public io.axoniq.axonserver.grpc.event.ScheduleToken scheduleEvent(io.axoniq.axonserver.grpc.event.ScheduleEventRequest request) {
      return blockingUnaryCall(
          getChannel(), getScheduleEventMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *  Cancel a scheduled event and schedule another in its place.
     * </pre>
     */
    public io.axoniq.axonserver.grpc.event.ScheduleToken rescheduleEvent(io.axoniq.axonserver.grpc.event.RescheduleEventRequest request) {
      return blockingUnaryCall(
          getChannel(), getRescheduleEventMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *  Cancel the publication of a scheduled event. If the events has already been published, this method does nothing.
     * </pre>
     */
    public io.axoniq.axonserver.grpc.InstructionAck cancelScheduledEvent(io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest request) {
      return blockingUnaryCall(
          getChannel(), getCancelScheduledEventMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Service to use AxonServer as a provider of an EventScheduler 
   * </pre>
   */
  public static final class EventSchedulerFutureStub extends io.grpc.stub.AbstractStub<EventSchedulerFutureStub> {
    private EventSchedulerFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private EventSchedulerFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected EventSchedulerFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new EventSchedulerFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     *  Schedule the given event for publication at the given time}. The returned ScheduleToken can be used to cancel the planned publication.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.event.ScheduleToken> scheduleEvent(
        io.axoniq.axonserver.grpc.event.ScheduleEventRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getScheduleEventMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *  Cancel a scheduled event and schedule another in its place.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.event.ScheduleToken> rescheduleEvent(
        io.axoniq.axonserver.grpc.event.RescheduleEventRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRescheduleEventMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *  Cancel the publication of a scheduled event. If the events has already been published, this method does nothing.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.axoniq.axonserver.grpc.InstructionAck> cancelScheduledEvent(
        io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCancelScheduledEventMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_SCHEDULE_EVENT = 0;
  private static final int METHODID_RESCHEDULE_EVENT = 1;
  private static final int METHODID_CANCEL_SCHEDULED_EVENT = 2;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final EventSchedulerImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(EventSchedulerImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_SCHEDULE_EVENT:
          serviceImpl.scheduleEvent((io.axoniq.axonserver.grpc.event.ScheduleEventRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.ScheduleToken>) responseObserver);
          break;
        case METHODID_RESCHEDULE_EVENT:
          serviceImpl.rescheduleEvent((io.axoniq.axonserver.grpc.event.RescheduleEventRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.event.ScheduleToken>) responseObserver);
          break;
        case METHODID_CANCEL_SCHEDULED_EVENT:
          serviceImpl.cancelScheduledEvent((io.axoniq.axonserver.grpc.event.CancelScheduledEventRequest) request,
              (io.grpc.stub.StreamObserver<io.axoniq.axonserver.grpc.InstructionAck>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class EventSchedulerBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    EventSchedulerBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.axoniq.axonserver.grpc.event.EventOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("EventScheduler");
    }
  }

  private static final class EventSchedulerFileDescriptorSupplier
      extends EventSchedulerBaseDescriptorSupplier {
    EventSchedulerFileDescriptorSupplier() {}
  }

  private static final class EventSchedulerMethodDescriptorSupplier
      extends EventSchedulerBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    EventSchedulerMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (EventSchedulerGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new EventSchedulerFileDescriptorSupplier())
              .addMethod(getScheduleEventMethod())
              .addMethod(getRescheduleEventMethod())
              .addMethod(getCancelScheduledEventMethod())
              .build();
        }
      }
    }
    return result;
  }
}
