/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class GrpcBufferingInterceptor
implements ClientInterceptor {
    private final int additionalBuffer;

    public GrpcBufferingInterceptor(int additionalBuffer) {
        this.additionalBuffer = additionalBuffer;
    }

    public <REQ, RESP> ClientCall<REQ, RESP> interceptCall(MethodDescriptor<REQ, RESP> method, CallOptions callOptions, Channel next) {
        ClientCall call = next.newCall(method, callOptions);
        if (this.additionalBuffer == 0 || method.getType().serverSendsOneMessage()) {
            return call;
        }
        return new AdditionalMessageRequestingCall(call, this.additionalBuffer);
    }

    private static class AdditionalMessageRequestingCall<REQ, RESP>
    extends ForwardingClientCall.SimpleForwardingClientCall<REQ, RESP> {
        private final int additionalBuffer;

        public AdditionalMessageRequestingCall(ClientCall<REQ, RESP> call, int additionalBuffer) {
            super(call);
            this.additionalBuffer = additionalBuffer;
        }

        public void start(ClientCall.Listener<RESP> responseListener, Metadata headers) {
            super.start(responseListener, headers);
            this.request(this.additionalBuffer);
        }
    }
}

