/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.grpc.stub.ClientCallStreamObserver;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class SynchronizedRequestStream<T>
extends ClientCallStreamObserver<T> {
    private final ClientCallStreamObserver<T> delegate;
    private final AtomicBoolean lock = new AtomicBoolean(false);

    public SynchronizedRequestStream(ClientCallStreamObserver<T> requestStream) {
        this.delegate = requestStream;
    }

    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        this.delegate.cancel(message, cause);
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        this.delegate.setOnReadyHandler(onReadyHandler);
    }

    public void disableAutoInboundFlowControl() {
        this.delegate.disableAutoInboundFlowControl();
    }

    public void request(int count) {
        this.delegate.request(count);
    }

    public void setMessageCompression(boolean enable) {
        this.delegate.setMessageCompression(enable);
    }

    public void onNext(T value) {
        this.inLock(() -> this.delegate.onNext(value));
    }

    public void onError(Throwable t) {
        this.inLock(() -> this.delegate.onError(t));
    }

    public void onCompleted() {
        this.inLock(() -> this.delegate.onCompleted());
    }

    private void inLock(Runnable action) {
        while (!this.lock.compareAndSet(false, true)) {
            Thread.yield();
        }
        try {
            action.run();
        }
        finally {
            this.lock.set(false);
        }
    }
}

