/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.impl.AxonServerManagedChannel;
import io.grpc.ConnectivityState;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAxonServerChannel {
    private final ScheduledExecutorService executor;
    private final AxonServerManagedChannel channel;

    public AbstractAxonServerChannel(ScheduledExecutorService executor, AxonServerManagedChannel axonServerManagedChannel) {
        this.executor = executor;
        this.channel = axonServerManagedChannel;
    }

    protected void scheduleReconnect() {
        this.executor.schedule(() -> {
            ConnectivityState connectivityState = this.channel.getState(false);
            if (connectivityState == ConnectivityState.READY) {
                this.connect();
            } else {
                this.scheduleReconnect();
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    public abstract void connect();

    public abstract void disconnect();

    public abstract boolean isConnected();
}

