/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl.buffer;

import io.axoniq.axonserver.connector.impl.AssertUtils;
import io.axoniq.axonserver.connector.impl.CloseableReadonlyBuffer;
import io.axoniq.axonserver.connector.impl.DisposableReadonlyBuffer;
import io.axoniq.axonserver.grpc.ErrorMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinMultiReadonlyBuffer<T>
implements DisposableReadonlyBuffer<T> {
    private final List<DisposableReadonlyBuffer<T>> buffers;
    private final AtomicInteger indexer = new AtomicInteger();

    public RoundRobinMultiReadonlyBuffer(List<? extends DisposableReadonlyBuffer<T>> buffers) {
        AssertUtils.assertParameter(buffers != null, "buffers must not be null");
        AssertUtils.assertParameter(!buffers.isEmpty(), "buffers must not be empty");
        this.buffers = new ArrayList<DisposableReadonlyBuffer<T>>(buffers);
    }

    @Override
    public Optional<T> poll() {
        for (int i = 0; i < this.buffers.size(); ++i) {
            Optional read = this.buffers.get(this.nextPosition()).poll();
            if (!read.isPresent()) continue;
            return read;
        }
        return Optional.empty();
    }

    @Override
    public boolean closed() {
        return this.buffers.stream().map(CloseableReadonlyBuffer::closed).reduce(true, Boolean::logicalAnd);
    }

    @Override
    public Optional<ErrorMessage> error() {
        boolean allInError = this.buffers.stream().map(b -> b.error().isPresent()).reduce(Boolean::logicalAnd).orElse(false);
        return allInError ? this.buffers.get(0).error() : Optional.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.buffers.stream().map(CloseableReadonlyBuffer::isEmpty).reduce(true, Boolean::logicalAnd);
    }

    @Override
    public int capacity() {
        return this.buffers.stream().map(CloseableReadonlyBuffer::capacity).reduce(0, Integer::sum);
    }

    @Override
    public void onAvailable(Runnable onAvailable) {
        this.buffers.forEach(b -> b.onAvailable(onAvailable));
    }

    @Override
    public void dispose() {
        this.buffers.forEach(DisposableReadonlyBuffer::dispose);
    }

    private int nextPosition() {
        return this.indexer.getAndUpdate(this::nextPositionBounded);
    }

    private int nextPositionBounded(int current) {
        return current + 1 == this.buffers.size() ? 0 : current + 1;
    }
}

