/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.configuration;

import io.awspring.cloud.sns.handlers.NotificationMessageHandlerMethodArgumentResolver;
import io.awspring.cloud.sns.handlers.NotificationStatusHandlerMethodArgumentResolver;
import io.awspring.cloud.sns.handlers.NotificationSubjectHandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import software.amazon.awssdk.services.sns.SnsClient;

public final class NotificationHandlerMethodArgumentResolverConfigurationUtils {
    private NotificationHandlerMethodArgumentResolverConfigurationUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static HandlerMethodArgumentResolver getNotificationHandlerMethodArgumentResolver(SnsClient snsClient) {
        Assert.notNull((Object)snsClient, (String)"snsClient is required");
        HandlerMethodArgumentResolverComposite composite = new HandlerMethodArgumentResolverComposite();
        composite.addResolver((HandlerMethodArgumentResolver)new NotificationStatusHandlerMethodArgumentResolver(snsClient));
        composite.addResolver((HandlerMethodArgumentResolver)new NotificationMessageHandlerMethodArgumentResolver());
        composite.addResolver((HandlerMethodArgumentResolver)new NotificationSubjectHandlerMethodArgumentResolver());
        return composite;
    }
}

